/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Ssh2Boolean;
import org.pcap4j.packet.Ssh2NameList;
import org.pcap4j.packet.namednumber.Ssh2MessageNumber;
import org.pcap4j.util.ByteArrays;

public final class Ssh2KexInitPacket
extends AbstractPacket {
    private static final long serialVersionUID = -2424080361918022468L;
    private final Ssh2KexInitHeader header;

    public static Ssh2KexInitPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Ssh2KexInitPacket(rawData, offset, length);
    }

    private Ssh2KexInitPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new Ssh2KexInitHeader(rawData, offset, length);
    }

    private Ssh2KexInitPacket(Builder builder) {
        if (builder == null || builder.cookie == null || builder.kexAlgorithms == null || builder.serverHostKeyAlgorithms == null || builder.encryptionAlgorithmsClientToServer == null || builder.encryptionAlgorithmsServerToClient == null || builder.macAlgorithmsClientToServer == null || builder.macAlgorithmsServerToClient == null || builder.compressionAlgorithmsClientToServer == null || builder.compressionAlgorithmsServerToClient == null || builder.languagesClientToServer == null || builder.languagesServerToClient == null || builder.firstKexPacketFollows == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.cookie: ").append(builder.cookie).append(" builder.kexAlgorithms: ").append(builder.kexAlgorithms).append(" builder.serverHostKeyAlgorithms: ").append(builder.serverHostKeyAlgorithms).append(" builder.encryptionAlgorithmsClientToServer: ").append(builder.encryptionAlgorithmsClientToServer).append(" builder.encryptionAlgorithmsServerToClient: ").append(builder.encryptionAlgorithmsServerToClient).append(" builder.macAlgorithmsClientToServer: ").append(builder.macAlgorithmsClientToServer).append(" builder.macAlgorithmsServerToClient: ").append(builder.macAlgorithmsServerToClient).append(" builder.compressionAlgorithmsClientToServer: ").append(builder.compressionAlgorithmsClientToServer).append(" builder.compressionAlgorithmsServerToClient: ").append(builder.compressionAlgorithmsServerToClient).append(" builder.languagesClientToServer: ").append(builder.languagesClientToServer).append(" builder.languagesServerToClient: ").append(builder.languagesServerToClient).append(" builder.firstKexPacketFollows: ").append(builder.firstKexPacketFollows);
            throw new NullPointerException(sb.toString());
        }
        this.header = new Ssh2KexInitHeader(builder);
    }

    @Override
    public Ssh2KexInitHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class Ssh2KexInitHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -2780304573850816908L;
        private final Ssh2MessageNumber messageNumber = Ssh2MessageNumber.SSH_MSG_KEXINIT;
        private final byte[] cookie;
        private final Ssh2NameList kexAlgorithms;
        private final Ssh2NameList serverHostKeyAlgorithms;
        private final Ssh2NameList encryptionAlgorithmsClientToServer;
        private final Ssh2NameList encryptionAlgorithmsServerToClient;
        private final Ssh2NameList macAlgorithmsClientToServer;
        private final Ssh2NameList macAlgorithmsServerToClient;
        private final Ssh2NameList compressionAlgorithmsClientToServer;
        private final Ssh2NameList compressionAlgorithmsServerToClient;
        private final Ssh2NameList languagesClientToServer;
        private final Ssh2NameList languagesServerToClient;
        private final Ssh2Boolean firstKexPacketFollows;
        private final int reserved;

        private Ssh2KexInitHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 62) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data is too short to build an SSH2 KEX init header. data: ").append(new String(rawData)).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            if (!Ssh2MessageNumber.getInstance(rawData[offset]).equals(Ssh2MessageNumber.SSH_MSG_KEXINIT)) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data is not an SSH2 KEX init message. data: ").append(new String(rawData)).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            int currentOffset = 1 + offset;
            int remainingLength = length - 1;
            this.cookie = ByteArrays.getSubArray(rawData, currentOffset, 16);
            this.kexAlgorithms = new Ssh2NameList(rawData, currentOffset += this.cookie.length, remainingLength -= this.cookie.length);
            this.serverHostKeyAlgorithms = new Ssh2NameList(rawData, currentOffset += this.kexAlgorithms.length(), remainingLength -= this.kexAlgorithms.length());
            this.encryptionAlgorithmsClientToServer = new Ssh2NameList(rawData, currentOffset += this.serverHostKeyAlgorithms.length(), remainingLength -= this.serverHostKeyAlgorithms.length());
            this.encryptionAlgorithmsServerToClient = new Ssh2NameList(rawData, currentOffset += this.encryptionAlgorithmsClientToServer.length(), remainingLength -= this.encryptionAlgorithmsClientToServer.length());
            this.macAlgorithmsClientToServer = new Ssh2NameList(rawData, currentOffset += this.encryptionAlgorithmsClientToServer.length(), remainingLength -= this.encryptionAlgorithmsClientToServer.length());
            this.macAlgorithmsServerToClient = new Ssh2NameList(rawData, currentOffset += this.macAlgorithmsClientToServer.length(), remainingLength -= this.macAlgorithmsClientToServer.length());
            this.compressionAlgorithmsClientToServer = new Ssh2NameList(rawData, currentOffset += this.macAlgorithmsServerToClient.length(), remainingLength -= this.macAlgorithmsServerToClient.length());
            this.compressionAlgorithmsServerToClient = new Ssh2NameList(rawData, currentOffset += this.compressionAlgorithmsClientToServer.length(), remainingLength -= this.compressionAlgorithmsClientToServer.length());
            this.languagesClientToServer = new Ssh2NameList(rawData, currentOffset += this.compressionAlgorithmsServerToClient.length(), remainingLength -= this.compressionAlgorithmsServerToClient.length());
            this.languagesServerToClient = new Ssh2NameList(rawData, currentOffset += this.languagesClientToServer.length(), remainingLength -= this.languagesClientToServer.length());
            currentOffset += this.languagesServerToClient.length();
            if ((remainingLength -= this.languagesServerToClient.length()) < 5) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data is too short to build an SSH2 KEX init header. data: ").append(new String(rawData)).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.firstKexPacketFollows = new Ssh2Boolean(rawData[currentOffset]);
            this.reserved = ByteArrays.getInt(rawData, ++currentOffset);
        }

        private Ssh2KexInitHeader(Builder builder) {
            this.cookie = ByteArrays.clone(builder.cookie);
            if (this.cookie.length != 16) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("cookie length must be 16. builder.cookie: ").append(ByteArrays.toHexString(builder.cookie, " "));
                throw new IllegalArgumentException(sb.toString());
            }
            this.kexAlgorithms = builder.kexAlgorithms;
            this.serverHostKeyAlgorithms = builder.serverHostKeyAlgorithms;
            this.encryptionAlgorithmsClientToServer = builder.encryptionAlgorithmsClientToServer;
            this.encryptionAlgorithmsServerToClient = builder.encryptionAlgorithmsServerToClient;
            this.macAlgorithmsClientToServer = builder.macAlgorithmsClientToServer;
            this.macAlgorithmsServerToClient = builder.macAlgorithmsServerToClient;
            this.compressionAlgorithmsClientToServer = builder.compressionAlgorithmsClientToServer;
            this.compressionAlgorithmsServerToClient = builder.compressionAlgorithmsServerToClient;
            this.languagesClientToServer = builder.languagesClientToServer;
            this.languagesServerToClient = builder.languagesServerToClient;
            this.firstKexPacketFollows = builder.firstKexPacketFollows;
            this.reserved = builder.reserved;
        }

        public Ssh2MessageNumber getMessageNumber() {
            return this.messageNumber;
        }

        public byte[] getCookie() {
            return ByteArrays.clone(this.cookie);
        }

        public Ssh2NameList getKexAlgorithms() {
            return this.kexAlgorithms;
        }

        public Ssh2NameList getServerHostKeyAlgorithms() {
            return this.serverHostKeyAlgorithms;
        }

        public Ssh2NameList getEncryptionAlgorithmsClientToServer() {
            return this.encryptionAlgorithmsClientToServer;
        }

        public Ssh2NameList getEncryptionAlgorithmsServerToClient() {
            return this.encryptionAlgorithmsServerToClient;
        }

        public Ssh2NameList getMacAlgorithmsClientToServer() {
            return this.macAlgorithmsClientToServer;
        }

        public Ssh2NameList getMacAlgorithmsServerToClient() {
            return this.macAlgorithmsServerToClient;
        }

        public Ssh2NameList getCompressionAlgorithmsClientToServer() {
            return this.compressionAlgorithmsClientToServer;
        }

        public Ssh2NameList getCompressionAlgorithmsServerToClient() {
            return this.compressionAlgorithmsServerToClient;
        }

        public Ssh2NameList getLanguagesClientToServer() {
            return this.languagesClientToServer;
        }

        public Ssh2NameList getLanguagesServerToClient() {
            return this.languagesServerToClient;
        }

        public Ssh2Boolean getFirstKexPacketFollows() {
            return this.firstKexPacketFollows;
        }

        public int getReserved() {
            return this.reserved;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(new byte[]{(Byte)this.messageNumber.value()});
            rawFields.add(this.cookie);
            rawFields.add(this.kexAlgorithms.getRawData());
            rawFields.add(this.serverHostKeyAlgorithms.getRawData());
            rawFields.add(this.encryptionAlgorithmsClientToServer.getRawData());
            rawFields.add(this.encryptionAlgorithmsServerToClient.getRawData());
            rawFields.add(this.macAlgorithmsClientToServer.getRawData());
            rawFields.add(this.macAlgorithmsServerToClient.getRawData());
            rawFields.add(this.compressionAlgorithmsClientToServer.getRawData());
            rawFields.add(this.compressionAlgorithmsServerToClient.getRawData());
            rawFields.add(this.languagesClientToServer.getRawData());
            rawFields.add(this.languagesServerToClient.getRawData());
            rawFields.add(this.firstKexPacketFollows.getRawData());
            rawFields.add(ByteArrays.toByteArray(this.reserved));
            return rawFields;
        }

        @Override
        protected int calcLength() {
            return this.getRawData().length;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[SSH2 KEX init Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Message Number: ").append(this.messageNumber).append(ls);
            sb.append("  cookie: ").append(ByteArrays.toHexString(this.cookie, " ")).append(ls);
            sb.append("  kex_algorithms: ").append(this.kexAlgorithms).append(ls);
            sb.append("  server_host_key_algorithms: ").append(this.serverHostKeyAlgorithms).append(ls);
            sb.append("  encryption_algorithms_client_to_server: ").append(this.encryptionAlgorithmsClientToServer).append(ls);
            sb.append("  encryption_algorithms_server_to_client: ").append(this.encryptionAlgorithmsServerToClient).append(ls);
            sb.append("  mac_algorithms_client_to_server: ").append(this.macAlgorithmsClientToServer).append(ls);
            sb.append("  mac_algorithms_server_to_client: ").append(this.macAlgorithmsServerToClient).append(ls);
            sb.append("  compression_algorithms_client_to_server: ").append(this.compressionAlgorithmsClientToServer).append(ls);
            sb.append("  compression_algorithms_server_to_client: ").append(this.compressionAlgorithmsServerToClient).append(ls);
            sb.append("  languages_client_to_server: ").append(this.languagesClientToServer).append(ls);
            sb.append("  languages_server_to_client: ").append(this.languagesServerToClient).append(ls);
            sb.append("  first_kex_packet_follows: ").append(this.firstKexPacketFollows).append(ls);
            sb.append("  reserved: ").append(ByteArrays.toHexString(this.reserved, " ")).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private byte[] cookie;
        private Ssh2NameList kexAlgorithms;
        private Ssh2NameList serverHostKeyAlgorithms;
        private Ssh2NameList encryptionAlgorithmsClientToServer;
        private Ssh2NameList encryptionAlgorithmsServerToClient;
        private Ssh2NameList macAlgorithmsClientToServer;
        private Ssh2NameList macAlgorithmsServerToClient;
        private Ssh2NameList compressionAlgorithmsClientToServer;
        private Ssh2NameList compressionAlgorithmsServerToClient;
        private Ssh2NameList languagesClientToServer;
        private Ssh2NameList languagesServerToClient;
        private Ssh2Boolean firstKexPacketFollows;
        private int reserved;

        public Builder() {
        }

        private Builder(Ssh2KexInitPacket packet) {
            this.cookie = packet.header.cookie;
            this.kexAlgorithms = packet.header.kexAlgorithms;
            this.serverHostKeyAlgorithms = packet.header.serverHostKeyAlgorithms;
            this.encryptionAlgorithmsClientToServer = packet.header.encryptionAlgorithmsClientToServer;
            this.encryptionAlgorithmsServerToClient = packet.header.encryptionAlgorithmsServerToClient;
            this.macAlgorithmsClientToServer = packet.header.macAlgorithmsClientToServer;
            this.macAlgorithmsServerToClient = packet.header.macAlgorithmsServerToClient;
            this.compressionAlgorithmsClientToServer = packet.header.compressionAlgorithmsClientToServer;
            this.compressionAlgorithmsServerToClient = packet.header.compressionAlgorithmsServerToClient;
            this.languagesClientToServer = packet.header.languagesClientToServer;
            this.languagesServerToClient = packet.header.languagesServerToClient;
            this.firstKexPacketFollows = packet.header.firstKexPacketFollows;
            this.reserved = packet.header.reserved;
        }

        public Builder cookie(byte[] cookie) {
            this.cookie = cookie;
            return this;
        }

        public Builder kexAlgorithms(Ssh2NameList kexAlgorithms) {
            this.kexAlgorithms = kexAlgorithms;
            return this;
        }

        public Builder serverHostKeyAlgorithms(Ssh2NameList serverHostKeyAlgorithms) {
            this.serverHostKeyAlgorithms = serverHostKeyAlgorithms;
            return this;
        }

        public Builder encryptionAlgorithmsClientToServer(Ssh2NameList encryptionAlgorithmsClientToServer) {
            this.encryptionAlgorithmsClientToServer = encryptionAlgorithmsClientToServer;
            return this;
        }

        public Builder encryptionAlgorithmsServerToClient(Ssh2NameList encryptionAlgorithmsServerToClient) {
            this.encryptionAlgorithmsServerToClient = encryptionAlgorithmsServerToClient;
            return this;
        }

        public Builder macAlgorithmsClientToServer(Ssh2NameList macAlgorithmsClientToServer) {
            this.macAlgorithmsClientToServer = macAlgorithmsClientToServer;
            return this;
        }

        public Builder macAlgorithmsServerToClient(Ssh2NameList macAlgorithmsServerToClient) {
            this.macAlgorithmsServerToClient = macAlgorithmsServerToClient;
            return this;
        }

        public Builder compressionAlgorithmsClientToServer(Ssh2NameList compressionAlgorithmsClientToServer) {
            this.compressionAlgorithmsClientToServer = compressionAlgorithmsClientToServer;
            return this;
        }

        public Builder compressionAlgorithmsServerToClient(Ssh2NameList compressionAlgorithmsServerToClient) {
            this.compressionAlgorithmsServerToClient = compressionAlgorithmsServerToClient;
            return this;
        }

        public Builder languagesClientToServer(Ssh2NameList languagesClientToServer) {
            this.languagesClientToServer = languagesClientToServer;
            return this;
        }

        public Builder languagesServerToClient(Ssh2NameList languagesServerToClient) {
            this.languagesServerToClient = languagesServerToClient;
            return this;
        }

        public Builder firstKexPacketFollows(Ssh2Boolean firstKexPacketFollows) {
            this.firstKexPacketFollows = firstKexPacketFollows;
            return this;
        }

        public Builder reserved(int reserved) {
            this.reserved = reserved;
            return this;
        }

        @Override
        public Ssh2KexInitPacket build() {
            return new Ssh2KexInitPacket(this);
        }
    }
}

