/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.ArpHardwareType;
import org.pcap4j.packet.namednumber.ArpOperation;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.util.ByteArrays;
import org.pcap4j.util.MacAddress;

public final class ArpPacket
extends AbstractPacket {
    private static final long serialVersionUID = 2232443026999119934L;
    private final ArpHeader header;

    public static ArpPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new ArpPacket(rawData, offset, length);
    }

    private ArpPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new ArpHeader(rawData, offset, length);
    }

    private ArpPacket(Builder builder) {
        if (builder == null || builder.hardwareType == null || builder.protocolType == null || builder.operation == null || builder.srcHardwareAddr == null || builder.srcProtocolAddr == null || builder.dstHardwareAddr == null || builder.dstProtocolAddr == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.hardwareType: ").append(builder.hardwareType).append(" builder.protocolType: ").append(builder.protocolType).append(" builder.operation: ").append(builder.operation).append(" builder.srcHardwareAddr: ").append(builder.srcHardwareAddr).append(" builder.srcProtocolAddr: ").append(builder.srcProtocolAddr).append(" builder.dstHardwareAddr: ").append(builder.dstHardwareAddr).append(" builder.dstProtocolAddr: ").append(builder.dstProtocolAddr);
            throw new NullPointerException(sb.toString());
        }
        this.header = new ArpHeader(builder);
    }

    @Override
    public ArpHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class ArpHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 2098135951321047828L;
        private static final int HARDWARE_TYPE_OFFSET = 0;
        private static final int HARDWARE_TYPE_SIZE = 2;
        private static final int PROTOCOL_TYPE_OFFSET = 2;
        private static final int PROTOCOL_TYPE_SIZE = 2;
        private static final int HARDWARE_LENGTH_OFFSET = 4;
        private static final int HARDWARE_LENGTH_SIZE = 1;
        private static final int PROTOCOL_LENGTH_OFFSET = 5;
        private static final int PROTOCOL_LENGTH_SIZE = 1;
        private static final int OPERATION_OFFSET = 6;
        private static final int OPERATION_SIZE = 2;
        private static final int SRC_HARDWARE_ADDR_OFFSET = 8;
        private static final int SRC_HARDWARE_ADDR_SIZE = 6;
        private static final int SRC_PROTOCOL_ADDR_OFFSET = 14;
        private static final int SRC_PROTOCOL_ADDR_SIZE = 4;
        private static final int DST_HARDWARE_ADDR_OFFSET = 18;
        private static final int DST_HARDWARE_ADDR_SIZE = 6;
        private static final int DST_PROTOCOL_ADDR_OFFSET = 24;
        private static final int DST_PROTOCOL_ADDR_SIZE = 4;
        private static final int ARP_HEADER_SIZE = 28;
        private final ArpHardwareType hardwareType;
        private final EtherType protocolType;
        private final byte hardwareLength;
        private final byte protocolLength;
        private final ArpOperation operation;
        private final MacAddress srcHardwareAddr;
        private final InetAddress srcProtocolAddr;
        private final MacAddress dstHardwareAddr;
        private final InetAddress dstProtocolAddr;

        private ArpHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 28) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("The data is too short to build an ARP header(").append(28).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.hardwareType = ArpHardwareType.getInstance(ByteArrays.getShort(rawData, 0 + offset));
            this.protocolType = EtherType.getInstance(ByteArrays.getShort(rawData, 2 + offset));
            this.hardwareLength = ByteArrays.getByte(rawData, 4 + offset);
            this.protocolLength = ByteArrays.getByte(rawData, 5 + offset);
            this.operation = ArpOperation.getInstance(ByteArrays.getShort(rawData, 6 + offset));
            this.srcHardwareAddr = ByteArrays.getMacAddress(rawData, 8 + offset);
            this.srcProtocolAddr = ByteArrays.getInet4Address(rawData, 14 + offset);
            this.dstHardwareAddr = ByteArrays.getMacAddress(rawData, 18 + offset);
            this.dstProtocolAddr = ByteArrays.getInet4Address(rawData, 24 + offset);
        }

        private ArpHeader(Builder builder) {
            this.hardwareType = builder.hardwareType;
            this.protocolType = builder.protocolType;
            this.hardwareLength = builder.hardwareLength;
            this.protocolLength = builder.protocolLength;
            this.operation = builder.operation;
            this.srcHardwareAddr = builder.srcHardwareAddr;
            this.srcProtocolAddr = builder.srcProtocolAddr;
            this.dstHardwareAddr = builder.dstHardwareAddr;
            this.dstProtocolAddr = builder.dstProtocolAddr;
        }

        public ArpHardwareType getHardwareType() {
            return this.hardwareType;
        }

        public EtherType getProtocolType() {
            return this.protocolType;
        }

        public byte getHardwareLength() {
            return this.hardwareLength;
        }

        public int getHardwareLengthAsInt() {
            return 0xFF & this.hardwareLength;
        }

        public byte getProtocolLength() {
            return this.protocolLength;
        }

        public int getProtocolLengthAsInt() {
            return 0xFF & this.protocolLength;
        }

        public ArpOperation getOperation() {
            return this.operation;
        }

        public MacAddress getSrcHardwareAddr() {
            return this.srcHardwareAddr;
        }

        public InetAddress getSrcProtocolAddr() {
            return this.srcProtocolAddr;
        }

        public MacAddress getDstHardwareAddr() {
            return this.dstHardwareAddr;
        }

        public InetAddress getDstProtocolAddr() {
            return this.dstProtocolAddr;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Short)this.hardwareType.value()));
            rawFields.add(ByteArrays.toByteArray((Short)this.protocolType.value()));
            rawFields.add(ByteArrays.toByteArray(this.hardwareLength));
            rawFields.add(ByteArrays.toByteArray(this.protocolLength));
            rawFields.add(ByteArrays.toByteArray((Short)this.operation.value()));
            rawFields.add(ByteArrays.toByteArray(this.srcHardwareAddr));
            rawFields.add(ByteArrays.toByteArray(this.srcProtocolAddr));
            rawFields.add(ByteArrays.toByteArray(this.dstHardwareAddr));
            rawFields.add(ByteArrays.toByteArray(this.dstProtocolAddr));
            return rawFields;
        }

        @Override
        public int length() {
            return 28;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ARP Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Hardware type: ").append(this.hardwareType).append(ls);
            sb.append("  Protocol type: ").append(this.protocolType).append(ls);
            sb.append("  Hardware length: ").append(this.getHardwareLengthAsInt()).append(" [bytes]").append(ls);
            sb.append("  Protocol length: ").append(this.getProtocolLengthAsInt()).append(" [bytes]").append(ls);
            sb.append("  Operation: ").append(this.operation).append(ls);
            sb.append("  Source hardware address: ").append(this.srcHardwareAddr).append(ls);
            sb.append("  Source protocol address: ").append(this.srcProtocolAddr).append(ls);
            sb.append("  Destination hardware address: ").append(this.dstHardwareAddr).append(ls);
            sb.append("  Destination protocol address: ").append(this.dstProtocolAddr).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private ArpHardwareType hardwareType;
        private EtherType protocolType;
        private byte hardwareLength;
        private byte protocolLength;
        private ArpOperation operation;
        private MacAddress srcHardwareAddr;
        private InetAddress srcProtocolAddr;
        private MacAddress dstHardwareAddr;
        private InetAddress dstProtocolAddr;

        public Builder() {
        }

        private Builder(ArpPacket packet) {
            this.hardwareType = packet.header.hardwareType;
            this.protocolType = packet.header.protocolType;
            this.hardwareLength = packet.header.hardwareLength;
            this.protocolLength = packet.header.protocolLength;
            this.operation = packet.header.operation;
            this.srcHardwareAddr = packet.header.srcHardwareAddr;
            this.srcProtocolAddr = packet.header.srcProtocolAddr;
            this.dstHardwareAddr = packet.header.dstHardwareAddr;
            this.dstProtocolAddr = packet.header.dstProtocolAddr;
        }

        public Builder hardwareType(ArpHardwareType hardwareType) {
            this.hardwareType = hardwareType;
            return this;
        }

        public Builder protocolType(EtherType protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        public Builder hardwareLength(byte hardwareLength) {
            this.hardwareLength = hardwareLength;
            return this;
        }

        public Builder protocolLength(byte protocolLength) {
            this.protocolLength = protocolLength;
            return this;
        }

        public Builder operation(ArpOperation operation) {
            this.operation = operation;
            return this;
        }

        public Builder srcHardwareAddr(MacAddress srcHardwareAddr) {
            this.srcHardwareAddr = srcHardwareAddr;
            return this;
        }

        public Builder srcProtocolAddr(InetAddress srcProtocolAddr) {
            this.srcProtocolAddr = srcProtocolAddr;
            return this;
        }

        public Builder dstHardwareAddr(MacAddress dstHardwareAddr) {
            this.dstHardwareAddr = dstHardwareAddr;
            return this;
        }

        public Builder dstProtocolAddr(InetAddress dstProtocolAddr) {
            this.dstProtocolAddr = dstProtocolAddr;
            return this;
        }

        @Override
        public ArpPacket build() {
            return new ArpPacket(this);
        }
    }
}

