/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import org.pcap4j.core.NativeMappings;

public final class BpfProgram {
    private final NativeMappings.bpf_program program;
    private final String expression;
    private volatile boolean freed = false;

    BpfProgram(NativeMappings.bpf_program program, String expression) {
        this.program = program;
        this.expression = expression;
    }

    NativeMappings.bpf_program getProgram() {
        return this.program;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isFreed() {
        return this.freed;
    }

    public void free() {
        NativeMappings.pcap_freecode(this.program);
        this.freed = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.free();
    }

    public static enum BpfCompileMode {
        OPTIMIZE(1),
        NONOPTIMIZE(0);

        private final int value;

        private BpfCompileMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

