/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class IcmpV6Type
extends NamedNumber<Byte, IcmpV6Type> {
    private static final long serialVersionUID = 9190204239119018362L;
    public static final IcmpV6Type DESTINATION_UNREACHABLE = new IcmpV6Type((byte)1, "Destination Unreachable");
    public static final IcmpV6Type PACKET_TOO_BIG = new IcmpV6Type((byte)2, "Packet Too Big");
    public static final IcmpV6Type TIME_EXCEEDED = new IcmpV6Type((byte)3, "Time Exceeded");
    public static final IcmpV6Type PARAMETER_PROBLEM = new IcmpV6Type((byte)4, "Parameter Problem");
    public static final IcmpV6Type ECHO_REQUEST = new IcmpV6Type((byte)-128, "Echo Request");
    public static final IcmpV6Type ECHO_REPLY = new IcmpV6Type((byte)-127, "Echo Reply");
    public static final IcmpV6Type ROUTER_SOLICITATION = new IcmpV6Type((byte)-123, "Router Solicitation");
    public static final IcmpV6Type ROUTER_ADVERTISEMENT = new IcmpV6Type((byte)-122, "Router Advertisement");
    public static final IcmpV6Type NEIGHBOR_SOLICITATION = new IcmpV6Type((byte)-121, "Neighbor Solicitation");
    public static final IcmpV6Type NEIGHBOR_ADVERTISEMENT = new IcmpV6Type((byte)-120, "Neighbor Advertisement");
    public static final IcmpV6Type REDIRECT = new IcmpV6Type((byte)-119, "Redirect");
    private static final Map<Byte, IcmpV6Type> registry = new HashMap<Byte, IcmpV6Type>();

    public IcmpV6Type(Byte value, String name) {
        super(value, name);
    }

    public static IcmpV6Type getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new IcmpV6Type(value, "unknown");
    }

    public static IcmpV6Type register(IcmpV6Type type) {
        return registry.put((Byte)type.value(), type);
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    @Override
    public int compareTo(IcmpV6Type o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    static {
        for (Field field : IcmpV6Type.class.getFields()) {
            if (!IcmpV6Type.class.isAssignableFrom(field.getType())) continue;
            try {
                IcmpV6Type f = (IcmpV6Type)field.get(null);
                registry.put((Byte)f.value(), f);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }
}

