/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.namednumber.TcpOptionKind;
import org.pcap4j.util.ByteArrays;

public final class TcpTimestampsOption
implements TcpPacket.TcpOption {
    private static final long serialVersionUID = -7134215148170658739L;
    private final TcpOptionKind kind = TcpOptionKind.TIMESTAMPS;
    private final byte length;
    private final int tsValue;
    private final int tsEchoReply;

    public static TcpTimestampsOption newInstance(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        return new TcpTimestampsOption(rawData);
    }

    private TcpTimestampsOption(byte[] rawData) throws IllegalRawDataException {
        if (rawData.length < 10) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("The raw data length must be more than 9. rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[0] != (Byte)this.kind.value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The kind must be: ").append(this.kind.valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[1] != 10) {
            throw new IllegalRawDataException("The value of length field must be 10 but: " + rawData[1]);
        }
        this.length = rawData[1];
        this.tsValue = ByteArrays.getInt(rawData, 2);
        this.tsEchoReply = ByteArrays.getInt(rawData, 6);
    }

    private TcpTimestampsOption(Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder: " + builder);
        }
        this.tsValue = builder.tsValue;
        this.tsEchoReply = builder.tsEchoReply;
        this.length = builder.correctLengthAtBuild ? (byte)this.length() : builder.length;
    }

    @Override
    public TcpOptionKind getKind() {
        return this.kind;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public int getTsValue() {
        return this.tsValue;
    }

    public long getTsValueAsLong() {
        return 0xFFFFFFFFL & (long)this.tsValue;
    }

    public int getTsEchoReply() {
        return this.tsEchoReply;
    }

    public long getTsEchoReplyAsLong() {
        return 0xFFFFFFFFL & (long)this.tsEchoReply;
    }

    @Override
    public int length() {
        return 10;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.kind.value();
        rawData[1] = this.length;
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Kind: ").append(this.kind);
        sb.append("] [Length: ").append(this.getLengthAsInt()).append(" bytes]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return Arrays.equals(((TcpTimestampsOption)this.getClass().cast(obj)).getRawData(), this.getRawData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getRawData());
    }

    public static final class Builder
    implements LengthBuilder<TcpTimestampsOption> {
        private byte length;
        private int tsValue;
        private int tsEchoReply;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(TcpTimestampsOption option) {
            this.length = option.length;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder tsValue(int tsValue) {
            this.tsValue = tsValue;
            return this;
        }

        public Builder tsEchoReply(int tsEchoReply) {
            this.tsEchoReply = tsEchoReply;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public TcpTimestampsOption build() {
            return new TcpTimestampsOption(this);
        }
    }
}

