/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.namednumber.IpV6NeighborDiscoveryOptionType;
import org.pcap4j.util.ByteArrays;
import org.pcap4j.util.MacAddress;

public final class IpV6NeighborDiscoveryTargetLinkLayerAddressOption
implements IcmpV6CommonPacket.IpV6NeighborDiscoveryOption {
    private static final long serialVersionUID = 172728262141108390L;
    private static final int TYPE_OFFSET = 0;
    private static final int TYPE_SIZE = 1;
    private static final int LENGTH_OFFSET = 1;
    private static final int LENGTH_SIZE = 1;
    private static final int LINK_LAYER_ADDRESS_OFFSET = 2;
    private final IpV6NeighborDiscoveryOptionType type = IpV6NeighborDiscoveryOptionType.TARGET_LINK_LAYER_ADDRESS;
    private final byte length;
    private final byte[] linkLayerAddress;

    public static IpV6NeighborDiscoveryTargetLinkLayerAddressOption newInstance(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        return new IpV6NeighborDiscoveryTargetLinkLayerAddressOption(rawData);
    }

    private IpV6NeighborDiscoveryTargetLinkLayerAddressOption(byte[] rawData) throws IllegalRawDataException {
        if (rawData.length < 8) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("The raw data length must be more than 7. rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[0] != (Byte)this.getType().value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The type must be: ").append(this.getType().valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        this.length = rawData[1];
        if (rawData.length < this.length * 8) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data is too short to build this option. ").append(this.length * 8).append(" bytes data is needed. data: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        this.linkLayerAddress = ByteArrays.getSubArray(rawData, 2, this.length * 8 - 2);
    }

    private IpV6NeighborDiscoveryTargetLinkLayerAddressOption(Builder builder) {
        if (builder == null || builder.linkLayerAddress == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.linkLayerAddress: ").append(builder.linkLayerAddress);
            throw new NullPointerException(sb.toString());
        }
        this.linkLayerAddress = new byte[builder.linkLayerAddress.length];
        System.arraycopy(builder.linkLayerAddress, 0, this.linkLayerAddress, 0, builder.linkLayerAddress.length);
        if (builder.correctLengthAtBuild) {
            if (this.length() % 8 != 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("linkLayerAddress's length is invalid. linkLayerAddress: ").append(ByteArrays.toHexString(this.linkLayerAddress, " "));
                throw new IllegalArgumentException(sb.toString());
            }
            this.length = (byte)(this.length() / 8);
        } else {
            this.length = builder.length;
        }
    }

    @Override
    public IpV6NeighborDiscoveryOptionType getType() {
        return this.type;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public byte[] getLinkLayerAddress() {
        byte[] copy = new byte[this.linkLayerAddress.length];
        System.arraycopy(this.linkLayerAddress, 0, copy, 0, this.linkLayerAddress.length);
        return copy;
    }

    public MacAddress getLinkLayerAddressAsMacAddress() {
        return MacAddress.getByAddress(this.linkLayerAddress);
    }

    @Override
    public int length() {
        return this.linkLayerAddress.length + 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getType().value();
        rawData[1] = this.length;
        System.arraycopy(this.linkLayerAddress, 0, rawData, 2, this.linkLayerAddress.length);
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Type: ").append(this.getType());
        sb.append("] [Length: ").append(this.getLengthAsInt()).append(" (").append(this.getLengthAsInt() * 8);
        sb.append(" bytes)] [linkLayerAddress: ").append(ByteArrays.toHexString(this.linkLayerAddress, " "));
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return Arrays.equals(((IpV6NeighborDiscoveryTargetLinkLayerAddressOption)this.getClass().cast(obj)).getRawData(), this.getRawData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getRawData());
    }

    public static final class Builder
    implements LengthBuilder<IpV6NeighborDiscoveryTargetLinkLayerAddressOption> {
        private byte length;
        private byte[] linkLayerAddress;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(IpV6NeighborDiscoveryTargetLinkLayerAddressOption option) {
            this.length = option.length;
            this.linkLayerAddress = option.linkLayerAddress;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder linkLayerAddress(byte[] linkLayerAddress) {
            this.linkLayerAddress = linkLayerAddress;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public IpV6NeighborDiscoveryTargetLinkLayerAddressOption build() {
            return new IpV6NeighborDiscoveryTargetLinkLayerAddressOption(this);
        }
    }
}

