/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.List;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6ExtOptionsPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.util.ByteArrays;

public final class IpV6ExtDestinationOptionsPacket
extends IpV6ExtOptionsPacket {
    private static final long serialVersionUID = -3293888276359687328L;
    private final IpV6ExtDestinationOptionsHeader header;

    public static IpV6ExtDestinationOptionsPacket newPacket(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        IpV6ExtDestinationOptionsHeader optHeader = new IpV6ExtDestinationOptionsHeader(rawData);
        int payloadLength = rawData.length - optHeader.length();
        if (payloadLength > 0) {
            byte[] rawPayload = ByteArrays.getSubArray(rawData, optHeader.length(), payloadLength);
            return new IpV6ExtDestinationOptionsPacket(rawPayload, optHeader);
        }
        return new IpV6ExtDestinationOptionsPacket(optHeader);
    }

    private IpV6ExtDestinationOptionsPacket(IpV6ExtDestinationOptionsHeader optHeader) {
        this.header = optHeader;
    }

    private IpV6ExtDestinationOptionsPacket(byte[] rawPayload, IpV6ExtDestinationOptionsHeader optHeader) {
        super(rawPayload, optHeader.getNextHeader());
        this.header = optHeader;
    }

    private IpV6ExtDestinationOptionsPacket(Builder builder) {
        super(builder);
        this.header = new IpV6ExtDestinationOptionsHeader(builder);
    }

    @Override
    public IpV6ExtDestinationOptionsHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IpV6ExtDestinationOptionsHeader
    extends IpV6ExtOptionsPacket.IpV6ExtOptionsHeader {
        private static final long serialVersionUID = 4686702407537705400L;

        private IpV6ExtDestinationOptionsHeader(byte[] rawData) throws IllegalRawDataException {
            super(rawData);
        }

        private IpV6ExtDestinationOptionsHeader(Builder builder) {
            super(builder);
        }

        @Override
        protected String getHeaderName() {
            return "IPv6 Destination Options Header";
        }
    }

    public static final class Builder
    extends IpV6ExtOptionsPacket.Builder {
        public Builder() {
        }

        private Builder(IpV6ExtDestinationOptionsPacket packet) {
            super(packet);
        }

        @Override
        public Builder nextHeader(IpNumber nextHeader) {
            super.nextHeader(nextHeader);
            return this;
        }

        @Override
        public Builder hdrExtLen(byte hdrExtLen) {
            super.hdrExtLen(hdrExtLen);
            return this;
        }

        @Override
        public Builder options(List<IpV6ExtOptionsPacket.IpV6Option> options) {
            super.options(options);
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            super.payloadBuilder(payloadBuilder);
            return this;
        }

        @Override
        public IpV6ExtDestinationOptionsPacket build() {
            return new IpV6ExtDestinationOptionsPacket(this);
        }
    }
}

