/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.util.ByteArrays;

public final class IllegalPacket
extends AbstractPacket {
    private static final long serialVersionUID = -8028013257441150031L;
    private final byte[] rawData;

    public static IllegalPacket newPacket(byte[] rawData) {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        return new IllegalPacket(rawData);
    }

    private IllegalPacket(byte[] rawData) {
        this.rawData = new byte[rawData.length];
        System.arraycopy(rawData, 0, this.rawData, 0, rawData.length);
    }

    private IllegalPacket(Builder builder) {
        if (builder == null || builder.rawData == null) {
            throw new NullPointerException();
        }
        this.rawData = new byte[builder.rawData.length];
        System.arraycopy(builder.rawData, 0, this.rawData, 0, builder.rawData.length);
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] copy = new byte[this.rawData.length];
        System.arraycopy(this.rawData, 0, copy, 0, copy.length);
        return copy;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    protected String buildString() {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append("[Illegal Packet (").append(this.length()).append(" bytes)]").append(ls);
        sb.append("  Hex stream: ").append(ByteArrays.toHexString(this.rawData, " ")).append(ls);
        return sb.toString();
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private byte[] rawData = new byte[0];

        public Builder() {
        }

        private Builder(IllegalPacket packet) {
            this.rawData = packet.rawData;
        }

        public Builder rawData(byte[] rawData) {
            this.rawData = rawData;
            return this;
        }

        @Override
        public IllegalPacket build() {
            return new IllegalPacket(this);
        }
    }
}

