/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV6InvokingPacketPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6PacketTooBigPacket
extends IcmpV6InvokingPacketPacket {
    private static final long serialVersionUID = -8558258364388627250L;
    private final IcmpV6PacketTooBigHeader header;

    public static IcmpV6PacketTooBigPacket newPacket(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        IcmpV6PacketTooBigHeader header = new IcmpV6PacketTooBigHeader(rawData);
        int payloadLength = rawData.length - header.length();
        if (payloadLength > 0) {
            byte[] rawPayload = ByteArrays.getSubArray(rawData, header.length(), payloadLength);
            return new IcmpV6PacketTooBigPacket(header, rawPayload);
        }
        return new IcmpV6PacketTooBigPacket(header);
    }

    private IcmpV6PacketTooBigPacket(IcmpV6PacketTooBigHeader header) {
        this.header = header;
    }

    private IcmpV6PacketTooBigPacket(IcmpV6PacketTooBigHeader header, byte[] rawPayload) {
        super(rawPayload);
        this.header = header;
    }

    private IcmpV6PacketTooBigPacket(Builder builder) {
        super(builder);
        this.header = new IcmpV6PacketTooBigHeader(builder);
    }

    @Override
    public IcmpV6PacketTooBigHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV6PacketTooBigHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 8034982803428261280L;
        private static final int MTU_OFFSET = 0;
        private static final int MTU_SIZE = 4;
        private static final int ICMPV6_PACKET_TOO_BIG_HEADER_SIZE = 4;
        private final int mtu;

        private IcmpV6PacketTooBigHeader(byte[] rawData) throws IllegalRawDataException {
            if (rawData.length < 4) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an ICMPv6 Packet Too Big Header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " "));
                throw new IllegalRawDataException(sb.toString());
            }
            this.mtu = ByteArrays.getInt(rawData, 0);
        }

        private IcmpV6PacketTooBigHeader(Builder builder) {
            this.mtu = builder.mtu;
        }

        public int getMtu() {
            return this.mtu;
        }

        public long getMtuAsLong() {
            return (long)this.mtu & 0xFFFFFFFFL;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.mtu));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ICMPv6 Packet Too Big Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  MTU: ").append(this.mtu).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends IcmpV6InvokingPacketPacket.Builder {
        private int mtu;

        public Builder() {
        }

        private Builder(IcmpV6PacketTooBigPacket packet) {
            super(packet);
            this.mtu = packet.getHeader().mtu;
        }

        public Builder mtu(int mtu) {
            this.mtu = mtu;
            return this;
        }

        @Override
        public Builder payload(Packet payload) {
            super.payload(payload);
            return this;
        }

        @Override
        public IcmpV6PacketTooBigPacket build() {
            return new IcmpV6PacketTooBigPacket(this);
        }
    }
}

