/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.net.Inet6Address;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.ChecksumBuilder;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.PacketPropertiesLoader;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.IcmpV6Code;
import org.pcap4j.packet.namednumber.IcmpV6Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpV6NeighborDiscoveryOptionType;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6CommonPacket
extends AbstractPacket {
    private static final long serialVersionUID = 7643067752830062365L;
    private final IcmpV6CommonHeader header;
    private final Packet payload;

    public static IcmpV6CommonPacket newPacket(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        return new IcmpV6CommonPacket(rawData);
    }

    private IcmpV6CommonPacket(byte[] rawData) throws IllegalRawDataException {
        this.header = new IcmpV6CommonHeader(rawData);
        int payloadLength = rawData.length - this.header.length();
        if (payloadLength > 0) {
            byte[] rawPayload = ByteArrays.getSubArray(rawData, this.header.length(), payloadLength);
            this.payload = PacketFactories.getFactory(Packet.class, IcmpV6Type.class).newInstance(rawPayload, this.header.getType());
        } else {
            this.payload = null;
        }
    }

    private IcmpV6CommonPacket(Builder builder) {
        if (builder == null || builder.type == null || builder.code == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.type: ").append(builder.type).append(" builder.code: ").append(builder.code);
            throw new NullPointerException(sb.toString());
        }
        if (builder.correctChecksumAtBuild && (builder.srcAddr == null || builder.dstAddr == null)) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder.srcAddr: ").append(builder.srcAddr).append(" builder.dstAddr: ").append(builder.dstAddr);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new IcmpV6CommonHeader(builder, this.payload.getRawData());
    }

    @Override
    public IcmpV6CommonHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public boolean hasValidChecksum(Inet6Address srcAddr, Inet6Address dstAddr, boolean acceptZero) {
        if (srcAddr == null || dstAddr == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("srcAddr: ").append(srcAddr).append(" dstAddr: ").append(dstAddr);
            throw new NullPointerException(sb.toString());
        }
        if (!srcAddr.getClass().isInstance(dstAddr)) {
            StringBuilder sb = new StringBuilder();
            sb.append("srcAddr: ").append(srcAddr).append(" dstAddr: ").append(dstAddr);
            throw new IllegalArgumentException(sb.toString());
        }
        if (this.header.checksum == 0) {
            return acceptZero;
        }
        if (this.payload != null) {
            return this.header.calcChecksum(srcAddr, dstAddr, this.payload.getRawData()) == this.header.checksum;
        }
        return this.header.calcChecksum(srcAddr, dstAddr, new byte[0]) == this.header.checksum;
    }

    public static interface IpV6NeighborDiscoveryOption
    extends Serializable {
        public IpV6NeighborDiscoveryOptionType getType();

        public int length();

        public byte[] getRawData();
    }

    public static final class IcmpV6CommonHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -7473322861606186L;
        private static final int TYPE_OFFSET = 0;
        private static final int TYPE_SIZE = 1;
        private static final int CODE_OFFSET = 1;
        private static final int CODE_SIZE = 1;
        private static final int CHECKSUM_OFFSET = 2;
        private static final int CHECKSUM_SIZE = 2;
        private static final int ICMPV6_COMMON_HEADER_SIZE = 4;
        private static final int ICMPV6_PSEUDO_HEADER_SIZE = 40;
        private final IcmpV6Type type;
        private final IcmpV6Code code;
        private final short checksum;

        private IcmpV6CommonHeader(byte[] rawData) throws IllegalRawDataException {
            if (rawData.length < 4) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an ICMPv6 common header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " "));
                throw new IllegalRawDataException(sb.toString());
            }
            this.type = IcmpV6Type.getInstance(ByteArrays.getByte(rawData, 0));
            this.code = IcmpV6Code.getInstance((Byte)this.type.value(), ByteArrays.getByte(rawData, 1));
            this.checksum = ByteArrays.getShort(rawData, 2);
        }

        private IcmpV6CommonHeader(Builder builder, byte[] payload) {
            this.type = builder.type;
            this.code = builder.code;
            this.checksum = builder.correctChecksumAtBuild ? (PacketPropertiesLoader.getInstance().icmpV6CalcChecksum() ? this.calcChecksum(builder.srcAddr, builder.dstAddr, payload) : (short)0) : builder.checksum;
        }

        private short calcChecksum(Inet6Address srcAddr, Inet6Address dstAddr, byte[] payload) {
            int destPos;
            byte[] data;
            int totalLength = payload.length + this.length();
            if (totalLength % 2 != 0) {
                data = new byte[totalLength + 1 + 40];
                destPos = totalLength + 1;
            } else {
                data = new byte[totalLength + 40];
                destPos = totalLength;
            }
            System.arraycopy(this.buildRawData(), 0, data, 0, this.length());
            System.arraycopy(payload, 0, data, this.length(), payload.length);
            for (int i = 0; i < 2; ++i) {
                data[2 + i] = 0;
            }
            System.arraycopy(srcAddr.getAddress(), 0, data, destPos, srcAddr.getAddress().length);
            System.arraycopy(dstAddr.getAddress(), 0, data, destPos += srcAddr.getAddress().length, dstAddr.getAddress().length);
            destPos += dstAddr.getAddress().length;
            data[destPos += 3] = (Byte)IpNumber.ICMPV6.value();
            System.arraycopy(ByteArrays.toByteArray((short)totalLength), 0, data, ++destPos, 2);
            destPos += 2;
            return ByteArrays.calcChecksum(data);
        }

        public IcmpV6Type getType() {
            return this.type;
        }

        public IcmpV6Code getCode() {
            return this.code;
        }

        public short getChecksum() {
            return this.checksum;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Byte)this.type.value()));
            rawFields.add(ByteArrays.toByteArray((Byte)this.code.value()));
            rawFields.add(ByteArrays.toByteArray(this.checksum));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ICMPv6 Common Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Type: ").append(this.type).append(ls);
            sb.append("  Code: ").append(this.code).append(ls);
            sb.append("  Checksum: 0x").append(ByteArrays.toHexString(this.checksum, "")).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder
    implements ChecksumBuilder<IcmpV6CommonPacket> {
        private IcmpV6Type type;
        private IcmpV6Code code;
        private short checksum;
        private Packet.Builder payloadBuilder;
        private Inet6Address srcAddr;
        private Inet6Address dstAddr;
        private boolean correctChecksumAtBuild;

        public Builder() {
        }

        private Builder(IcmpV6CommonPacket packet) {
            this.type = packet.header.type;
            this.code = packet.header.code;
            this.checksum = packet.header.checksum;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder type(IcmpV6Type type) {
            this.type = type;
            return this;
        }

        public Builder code(IcmpV6Code code) {
            this.code = code;
            return this;
        }

        public Builder checksum(short checksum) {
            this.checksum = checksum;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder srcAddr(Inet6Address srcAddr) {
            this.srcAddr = srcAddr;
            return this;
        }

        public Builder dstAddr(Inet6Address dstAddr) {
            this.dstAddr = dstAddr;
            return this;
        }

        public Builder correctChecksumAtBuild(boolean correctChecksumAtBuild) {
            this.correctChecksumAtBuild = correctChecksumAtBuild;
            return this;
        }

        @Override
        public IcmpV6CommonPacket build() {
            return new IcmpV6CommonPacket(this);
        }
    }
}

