/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.ChecksumBuilder;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.NA;
import org.pcap4j.util.IcmpV4Helper;

abstract class IcmpV4InvokingPacketPacket
extends AbstractPacket {
    private static final long serialVersionUID = -739710899445035385L;
    private final Packet payload;

    protected IcmpV4InvokingPacketPacket() {
        this.payload = null;
    }

    protected IcmpV4InvokingPacketPacket(byte[] rawPayload) {
        if (rawPayload == null) {
            throw new NullPointerException("rawPayload must not be null.");
        }
        if (rawPayload.length == 0) {
            throw new IllegalArgumentException("rawPayload is empty.");
        }
        Packet p = PacketFactories.getFactory(Packet.class, EtherType.class).newInstance(rawPayload, EtherType.IPV4);
        if (p instanceof IllegalPacket) {
            this.payload = p;
            return;
        }
        if (p.contains(IllegalPacket.class)) {
            Packet.Builder builder = p.getBuilder();
            builder.getOuterOf(IllegalPacket.Builder.class).payloadBuilder(PacketFactories.getFactory(Packet.class, NA.class).newInstance(p.get(IllegalPacket.class).getRawData()).getBuilder());
            for (Packet.Builder b : builder) {
                if (b instanceof LengthBuilder) {
                    ((LengthBuilder)((Object)b)).correctLengthAtBuild(false);
                }
                if (!(b instanceof ChecksumBuilder)) continue;
                ((ChecksumBuilder)((Object)b)).correctChecksumAtBuild(false);
            }
            p = builder.build();
        }
        this.payload = IcmpV4Helper.makePacketForInvokingPacketField(p);
    }

    protected IcmpV4InvokingPacketPacket(Builder builder) {
        if (builder == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payload;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    static abstract class Builder
    extends AbstractPacket.AbstractBuilder {
        private Packet payload;

        public Builder() {
        }

        protected Builder(IcmpV4InvokingPacketPacket packet) {
            this.payload = packet.payload;
        }

        public Builder payload(Packet payload) {
            this.payload = payload;
            return this;
        }
    }
}

