/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IcmpIdentifiablePacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.NA;
import org.pcap4j.util.ByteArrays;

public final class IcmpV4EchoReplyPacket
extends IcmpIdentifiablePacket {
    private static final long serialVersionUID = -7353440327689688935L;
    private final IcmpV4EchoReplyHeader header;
    private final Packet payload;

    public static IcmpV4EchoReplyPacket newPacket(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        return new IcmpV4EchoReplyPacket(rawData);
    }

    private IcmpV4EchoReplyPacket(byte[] rawData) throws IllegalRawDataException {
        this.header = new IcmpV4EchoReplyHeader(rawData);
        int payloadLength = rawData.length - this.header.length();
        if (payloadLength > 0) {
            byte[] rawPayload = ByteArrays.getSubArray(rawData, this.header.length(), payloadLength);
            this.payload = PacketFactories.getFactory(Packet.class, NA.class).newInstance(rawPayload);
        } else {
            this.payload = null;
        }
    }

    private IcmpV4EchoReplyPacket(Builder builder) {
        super(builder);
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new IcmpV4EchoReplyHeader(builder);
    }

    @Override
    public IcmpV4EchoReplyHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV4EchoReplyHeader
    extends IcmpIdentifiablePacket.IcmpIdentifiableHeader {
        private static final long serialVersionUID = 8044479519522316613L;

        private IcmpV4EchoReplyHeader(byte[] rawData) throws IllegalRawDataException {
            super(rawData);
        }

        private IcmpV4EchoReplyHeader(Builder builder) {
            super(builder);
        }

        @Override
        protected String getHeaderName() {
            return "ICMPv4 Echo Reply Header";
        }
    }

    public static final class Builder
    extends IcmpIdentifiablePacket.Builder {
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        private Builder(IcmpV4EchoReplyPacket packet) {
            super(packet);
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        @Override
        public Builder identifier(short identifier) {
            super.identifier(identifier);
            return this;
        }

        @Override
        public Builder sequenceNumber(short sequenceNumber) {
            super.sequenceNumber(sequenceNumber);
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        @Override
        public IcmpV4EchoReplyPacket build() {
            return new IcmpV4EchoReplyPacket(this);
        }
    }
}

