/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.ChecksumBuilder;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.PacketPropertiesLoader;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.IcmpV4Code;
import org.pcap4j.packet.namednumber.IcmpV4Type;
import org.pcap4j.util.ByteArrays;

public final class IcmpV4CommonPacket
extends AbstractPacket {
    private static final long serialVersionUID = 7643067752830062365L;
    private final IcmpV4CommonHeader header;
    private final Packet payload;

    public static IcmpV4CommonPacket newPacket(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        return new IcmpV4CommonPacket(rawData);
    }

    private IcmpV4CommonPacket(byte[] rawData) throws IllegalRawDataException {
        this.header = new IcmpV4CommonHeader(rawData);
        int payloadLength = rawData.length - this.header.length();
        if (payloadLength > 0) {
            byte[] rawPayload = ByteArrays.getSubArray(rawData, this.header.length(), payloadLength);
            this.payload = PacketFactories.getFactory(Packet.class, IcmpV4Type.class).newInstance(rawPayload, this.header.getType());
        } else {
            this.payload = null;
        }
    }

    private IcmpV4CommonPacket(Builder builder) {
        if (builder == null || builder.type == null || builder.code == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.type: ").append(builder.type).append(" builder.code: ").append(builder.code);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new IcmpV4CommonHeader(builder, this.payload != null ? this.payload.getRawData() : new byte[]{});
    }

    @Override
    public IcmpV4CommonHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public boolean hasValidChecksum(boolean acceptZero) {
        if (this.header.checksum == 0) {
            return acceptZero;
        }
        if (this.payload != null) {
            return this.header.calcChecksum(this.payload.getRawData()) == this.header.checksum;
        }
        return this.header.calcChecksum(new byte[0]) == this.header.checksum;
    }

    public static final class IcmpV4CommonHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 504881105187659087L;
        private static final int TYPE_OFFSET = 0;
        private static final int TYPE_SIZE = 1;
        private static final int CODE_OFFSET = 1;
        private static final int CODE_SIZE = 1;
        private static final int CHECKSUM_OFFSET = 2;
        private static final int CHECKSUM_SIZE = 2;
        private static final int ICMPV4_COMMON_HEADER_SIZE = 4;
        private final IcmpV4Type type;
        private final IcmpV4Code code;
        private final short checksum;

        private IcmpV4CommonHeader(byte[] rawData) throws IllegalRawDataException {
            if (rawData.length < 4) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an ICMPv4 common header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " "));
                throw new IllegalRawDataException(sb.toString());
            }
            this.type = IcmpV4Type.getInstance(ByteArrays.getByte(rawData, 0));
            this.code = IcmpV4Code.getInstance((Byte)this.type.value(), ByteArrays.getByte(rawData, 1));
            this.checksum = ByteArrays.getShort(rawData, 2);
        }

        private IcmpV4CommonHeader(Builder builder, byte[] payload) {
            this.type = builder.type;
            this.code = builder.code;
            this.checksum = builder.correctChecksumAtBuild ? (PacketPropertiesLoader.getInstance().icmpV4CalcChecksum() ? this.calcChecksum(payload) : (short)0) : builder.checksum;
        }

        private short calcChecksum(byte[] payload) {
            int packetLength = payload.length + this.length();
            byte[] data = packetLength % 2 != 0 ? new byte[packetLength + 1] : new byte[packetLength];
            System.arraycopy(this.buildRawData(), 0, data, 0, this.length());
            System.arraycopy(payload, 0, data, this.length(), payload.length);
            for (int i = 0; i < 2; ++i) {
                data[2 + i] = 0;
            }
            return ByteArrays.calcChecksum(data);
        }

        public IcmpV4Type getType() {
            return this.type;
        }

        public IcmpV4Code getCode() {
            return this.code;
        }

        public short getChecksum() {
            return this.checksum;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Byte)this.type.value()));
            rawFields.add(ByteArrays.toByteArray((Byte)this.code.value()));
            rawFields.add(ByteArrays.toByteArray(this.checksum));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ICMPv4 Common Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Type: ").append(this.type).append(ls);
            sb.append("  Code: ").append(this.code).append(ls);
            sb.append("  Checksum: 0x").append(ByteArrays.toHexString(this.checksum, "")).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder
    implements ChecksumBuilder<IcmpV4CommonPacket> {
        private IcmpV4Type type;
        private IcmpV4Code code;
        private short checksum;
        private Packet.Builder payloadBuilder;
        private boolean correctChecksumAtBuild;

        public Builder() {
        }

        private Builder(IcmpV4CommonPacket packet) {
            this.type = packet.header.type;
            this.code = packet.header.code;
            this.checksum = packet.header.checksum;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder type(IcmpV4Type type) {
            this.type = type;
            return this;
        }

        public Builder code(IcmpV4Code code) {
            this.code = code;
            return this;
        }

        public Builder checksum(short checksum) {
            this.checksum = checksum;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder correctChecksumAtBuild(boolean correctChecksumAtBuild) {
            this.correctChecksumAtBuild = correctChecksumAtBuild;
            return this;
        }

        @Override
        public IcmpV4CommonPacket build() {
            return new IcmpV4CommonPacket(this);
        }
    }
}

