/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class IpV4TosTos
extends NamedNumber<Byte, IpV4TosTos> {
    private static final long serialVersionUID = -7507790549660176346L;
    public static final IpV4TosTos DEFAULT = new IpV4TosTos((byte)0, "Default");
    public static final IpV4TosTos MINIMIZE_MONETARY_COST = new IpV4TosTos((byte)1, "Minimize Monetary Cost");
    public static final IpV4TosTos MAXIMIZE_RELIABILITY = new IpV4TosTos((byte)2, "Maximize Reliability");
    public static final IpV4TosTos MAXIMIZE_THROUGHPUT = new IpV4TosTos((byte)4, "Maximize Throughput");
    public static final IpV4TosTos MINIMIZE_DELAY = new IpV4TosTos((byte)8, "Minimize Delay");
    public static final IpV4TosTos MAXIMIZE_SECURITY = new IpV4TosTos((byte)15, "Maximize Security");
    private static final Map<Byte, IpV4TosTos> registry = new HashMap<Byte, IpV4TosTos>();

    public IpV4TosTos(Byte value, String name) {
        super(value, name);
        if ((value & 0xF0) != 0) {
            throw new IllegalArgumentException(value + " is invalid value. " + "TOS field of IPv4 TOS must be between 0 and 15");
        }
    }

    public static IpV4TosTos getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new IpV4TosTos(value, "unknown");
    }

    public static IpV4TosTos register(IpV4TosTos tos) {
        return registry.put((Byte)tos.value(), tos);
    }

    @Override
    public int compareTo(IpV4TosTos o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    static {
        for (Field field : IpV4TosTos.class.getFields()) {
            if (!IpV4TosTos.class.isAssignableFrom(field.getType())) continue;
            try {
                IpV4TosTos f = (IpV4TosTos)field.get(null);
                registry.put((Byte)f.value(), f);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }
}

