/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.ObjectStreamException;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.namednumber.TcpOptionKind;
import org.pcap4j.util.ByteArrays;

public final class TcpSackPermittedOption
implements TcpPacket.TcpOption {
    private static final long serialVersionUID = -5364948716212977767L;
    private static final TcpSackPermittedOption INSTANCE = new TcpSackPermittedOption();
    private final TcpOptionKind kind = TcpOptionKind.SACK_PERMITTED;
    private final byte length = (byte)2;

    private TcpSackPermittedOption() {
    }

    public static TcpSackPermittedOption getInstance() {
        return INSTANCE;
    }

    public static TcpSackPermittedOption newInstance(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        return new TcpSackPermittedOption(rawData);
    }

    private TcpSackPermittedOption(byte[] rawData) throws IllegalRawDataException {
        if (rawData.length < 2) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("The raw data length must be more than 1. rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[0] != (Byte)this.kind.value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The kind must be: ").append(this.kind.valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[1] != 2) {
            throw new IllegalRawDataException("The value of length field must be 2 but: " + rawData[1]);
        }
    }

    @Override
    public TcpOptionKind getKind() {
        return this.kind;
    }

    public byte getLength() {
        return 2;
    }

    public int getLengthAsInt() {
        return 2;
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.kind.value();
        rawData[1] = 2;
        return rawData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Kind: ").append(this.kind);
        sb.append("] [Length: ").append(this.getLengthAsInt()).append(" bytes]");
        return sb.toString();
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

