/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import org.pcap4j.util.ByteArrays;

public final class Ssh2Boolean
implements Serializable {
    private static final long serialVersionUID = 951415749644317915L;
    public static final Ssh2Boolean TRUE = new Ssh2Boolean(1);
    public static final Ssh2Boolean FALSE = new Ssh2Boolean(0);
    private final byte rawData;

    public Ssh2Boolean(byte rawData) {
        this.rawData = rawData;
    }

    public Ssh2Boolean(byte[] rawData) {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        this.rawData = rawData[0];
    }

    public boolean getValue() {
        return this.rawData != 0;
    }

    public int length() {
        return 1;
    }

    public byte[] getRawData() {
        return new byte[]{this.rawData};
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(10);
        sb.append(this.getValue()).append("(0x").append(ByteArrays.toHexString(this.rawData, "")).append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return ((Ssh2Boolean)obj).rawData == this.rawData;
    }

    public int hashCode() {
        return this.rawData;
    }
}

