/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpV6RoutingHeaderType;
import org.pcap4j.util.ByteArrays;

public final class IpV6ExtRoutingPacket
extends AbstractPacket {
    private static final long serialVersionUID = -4454872145403587056L;
    private final IpV6ExtRoutingHeader header;
    private final Packet payload;

    public static IpV6ExtRoutingPacket newPacket(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        return new IpV6ExtRoutingPacket(rawData);
    }

    private IpV6ExtRoutingPacket(byte[] rawData) throws IllegalRawDataException {
        this.header = new IpV6ExtRoutingHeader(rawData);
        int payloadLength = rawData.length - this.header.length();
        if (payloadLength > 0) {
            byte[] rawPayload = ByteArrays.getSubArray(rawData, this.header.length(), payloadLength);
            this.payload = PacketFactories.getFactory(Packet.class, IpNumber.class).newInstance(rawPayload, this.header.getNextHeader());
        } else {
            this.payload = null;
        }
    }

    private IpV6ExtRoutingPacket(Builder builder) {
        if (builder == null || builder.nextHeader == null || builder.data == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.nextHeader: ").append(builder.nextHeader).append(" builder.data: ").append(builder.data);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new IpV6ExtRoutingHeader(builder);
    }

    @Override
    public IpV6ExtRoutingHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static interface IpV6RoutingData
    extends Serializable {
        public int length();

        public byte[] getRawData();
    }

    public static final class IpV6ExtRoutingHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 773193868313443164L;
        private static final int NEXT_HEADER_OFFSET = 0;
        private static final int NEXT_HEADER_SIZE = 1;
        private static final int HDR_EXT_LEN_OFFSET = 1;
        private static final int HDR_EXT_LEN_SIZE = 1;
        private static final int ROUTING_TYPE_OFFSET = 2;
        private static final int ROUTING_TYPE_SIZE = 1;
        private static final int SEGMENTS_LEFT_OFFSET = 3;
        private static final int SEGMENTS_LEFT_SIZE = 1;
        private static final int TYPE_SPECIFIC_DATA_OFFSET = 4;
        private final IpNumber nextHeader;
        private final byte hdrExtLen;
        private final IpV6RoutingHeaderType routingType;
        private final byte segmentsLeft;
        private final IpV6RoutingData data;

        private IpV6ExtRoutingHeader(byte[] rawData) throws IllegalRawDataException {
            if (rawData.length < 4) {
                StringBuilder sb = new StringBuilder(110);
                sb.append("The data length of IPv6 routing header is must be more than 3. data: ").append(ByteArrays.toHexString(rawData, " "));
                throw new IllegalRawDataException(sb.toString());
            }
            this.nextHeader = IpNumber.getInstance(ByteArrays.getByte(rawData, 0));
            this.hdrExtLen = ByteArrays.getByte(rawData, 1);
            int headerLength = ((this.hdrExtLen & 0xFF) + 1) * 8;
            if (rawData.length < headerLength) {
                StringBuilder sb = new StringBuilder(110);
                sb.append("The data is too short to build an IPv6 routing header(").append(headerLength).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " "));
                throw new IllegalRawDataException(sb.toString());
            }
            this.routingType = IpV6RoutingHeaderType.getInstance(ByteArrays.getByte(rawData, 2));
            this.segmentsLeft = ByteArrays.getByte(rawData, 3);
            this.data = PacketFactories.getFactory(IpV6RoutingData.class, IpV6RoutingHeaderType.class).newInstance(ByteArrays.getSubArray(rawData, 4, headerLength - 4), this.routingType);
        }

        private IpV6ExtRoutingHeader(Builder builder) {
            if (builder.data.length() < 4) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("data length must be more than 3. data: ").append(builder.data);
                throw new IllegalArgumentException(sb.toString());
            }
            if ((builder.data.length() + 4) % 8 != 0) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("(builder.data.length() + 8 ) % 8 must be 0. data: ").append(builder.data);
                throw new IllegalArgumentException(sb.toString());
            }
            this.nextHeader = builder.nextHeader;
            this.routingType = builder.routingType;
            this.segmentsLeft = builder.segmentsLeft;
            this.data = builder.data;
            this.hdrExtLen = builder.correctLengthAtBuild ? (byte)((this.data.length() + 4) / 8 - 1) : builder.hdrExtLen;
        }

        public IpNumber getNextHeader() {
            return this.nextHeader;
        }

        public byte getHdrExtLen() {
            return this.hdrExtLen;
        }

        public int getHdrExtLenAsInt() {
            return 0xFF & this.hdrExtLen;
        }

        public IpV6RoutingHeaderType getRoutingType() {
            return this.routingType;
        }

        public byte getSegmentsLeft() {
            return this.segmentsLeft;
        }

        public int getSegmentsLeftAsInt() {
            return this.segmentsLeft & 0xFF;
        }

        public IpV6RoutingData getData() {
            return this.data;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Byte)this.nextHeader.value()));
            rawFields.add(ByteArrays.toByteArray(this.hdrExtLen));
            rawFields.add(ByteArrays.toByteArray((Byte)this.routingType.value()));
            rawFields.add(ByteArrays.toByteArray(this.segmentsLeft));
            rawFields.add(this.data.getRawData());
            return rawFields;
        }

        @Override
        public int calcLength() {
            return this.data.length() + 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[IPv6 Routing Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Next Header: ").append(this.nextHeader).append(ls);
            sb.append("  Hdr Ext Len: ").append(this.getHdrExtLenAsInt()).append(" (").append((this.getHdrExtLenAsInt() + 1) * 8).append(" [bytes])").append(ls);
            sb.append("  Routing Type: ").append(this.routingType).append(ls);
            sb.append("  Segments Left: ").append(this.getSegmentsLeftAsInt()).append(ls);
            sb.append("  type-specific data: ").append(this.data).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder
    implements LengthBuilder<IpV6ExtRoutingPacket> {
        private IpNumber nextHeader;
        private byte hdrExtLen;
        private IpV6RoutingHeaderType routingType;
        private byte segmentsLeft;
        private IpV6RoutingData data;
        private Packet.Builder payloadBuilder;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        public Builder(IpV6ExtRoutingPacket packet) {
            this.nextHeader = packet.header.nextHeader;
            this.hdrExtLen = packet.header.hdrExtLen;
            this.routingType = packet.header.routingType;
            this.segmentsLeft = packet.header.segmentsLeft;
            this.data = packet.header.data;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder nextHeader(IpNumber nextHeader) {
            this.nextHeader = nextHeader;
            return this;
        }

        public Builder hdrExtLen(byte hdrExtLen) {
            this.hdrExtLen = hdrExtLen;
            return this;
        }

        public Builder routingType(IpV6RoutingHeaderType routingType) {
            this.routingType = routingType;
            return this;
        }

        public Builder segmentsLeft(byte segmentsLeft) {
            this.segmentsLeft = segmentsLeft;
            return this;
        }

        public Builder data(IpV6RoutingData data) {
            this.data = data;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public IpV6ExtRoutingPacket build() {
            return new IpV6ExtRoutingPacket(this);
        }
    }
}

