/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.namednumber.IpV4OptionType;
import org.pcap4j.util.ByteArrays;

abstract class IpV4RouteOption
implements IpV4Packet.IpV4Option {
    private static final long serialVersionUID = -2747065348720047861L;
    private final byte length;
    private final byte pointer;
    private final List<Inet4Address> routeData;

    protected IpV4RouteOption(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        if (rawData.length < 3) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data length must be more than 2. rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[0] != (Byte)this.getType().value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The type must be: ").append(this.getType().valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        this.length = rawData[1];
        if (rawData.length < this.length) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data is too short to build this option(").append(this.length).append("). data: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        if ((this.length - 3) % 4 != 0) {
            throw new IllegalRawDataException("Invalid length for this option: " + this.length);
        }
        this.pointer = rawData[2];
        this.routeData = new ArrayList<Inet4Address>();
        for (int i = 3; i < this.length; i += 4) {
            this.routeData.add(ByteArrays.getInet4Address(rawData, i));
        }
    }

    protected IpV4RouteOption(Builder<? extends IpV4RouteOption> builder) {
        if (builder == null || ((Builder)builder).routeData == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.routeData: ").append(((Builder)builder).routeData);
            throw new NullPointerException(sb.toString());
        }
        this.pointer = ((Builder)builder).pointer;
        this.routeData = new ArrayList<Inet4Address>(((Builder)builder).routeData);
        this.length = ((Builder)builder).correctLengthAtBuild ? (byte)this.length() : ((Builder)builder).length;
    }

    @Override
    public abstract IpV4OptionType getType();

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public byte getPointer() {
        return this.pointer;
    }

    public int getPointerAsInt() {
        return 0xFF & this.pointer;
    }

    public List<Inet4Address> getRouteData() {
        return new ArrayList<Inet4Address>(this.routeData);
    }

    @Override
    public int length() {
        return this.routeData.size() * 4 + 3;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getType().value();
        rawData[1] = this.length;
        rawData[2] = this.pointer;
        int i = 3;
        for (Inet4Address addr : this.routeData) {
            System.arraycopy(addr.getAddress(), 0, rawData, i, 4);
            i += 4;
        }
        return rawData;
    }

    public abstract Builder<? extends IpV4RouteOption> getBuilder();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[option-type: ").append(this.getType());
        sb.append("] [option-length: ").append(this.getLengthAsInt());
        sb.append(" bytes] [pointer: ").append(this.getPointerAsInt());
        sb.append("] [route data:");
        for (Inet4Address addr : this.routeData) {
            sb.append(" ").append(addr);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return Arrays.equals(((IpV4RouteOption)this.getClass().cast(obj)).getRawData(), this.getRawData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getRawData());
    }

    static abstract class Builder<T extends IpV4RouteOption>
    implements LengthBuilder<T> {
        private byte length;
        private byte pointer;
        private List<Inet4Address> routeData;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        protected Builder(IpV4RouteOption option) {
            this.length = option.length;
            this.pointer = option.pointer;
            this.routeData = option.routeData;
        }

        public Builder<T> length(byte length) {
            this.length = length;
            return this;
        }

        public Builder<T> pointer(byte pointer) {
            this.pointer = pointer;
            return this;
        }

        public Builder<T> routeData(List<Inet4Address> routeData) {
            this.routeData = routeData;
            return this;
        }

        @Override
        public Builder<T> correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public abstract T build();
    }
}

