/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.namednumber.TcpOptionKind;
import org.pcap4j.util.ByteArrays;

public final class IllegalTcpOption
implements TcpPacket.TcpOption {
    private static final long serialVersionUID = 4128600756828920489L;
    private final TcpOptionKind kind;
    private final byte[] rawData;

    public static IllegalTcpOption newInstance(byte[] rawData) {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        return new IllegalTcpOption(rawData);
    }

    private IllegalTcpOption(byte[] rawData) {
        this.kind = TcpOptionKind.getInstance(rawData[0]);
        this.rawData = new byte[rawData.length];
        System.arraycopy(rawData, 0, this.rawData, 0, rawData.length);
    }

    private IllegalTcpOption(Builder builder) {
        if (builder == null || builder.kind == null || builder.rawData == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.kind: ").append(builder.kind).append(" builder.rawData: ").append(builder.rawData);
            throw new NullPointerException(sb.toString());
        }
        this.kind = builder.kind;
        this.rawData = new byte[builder.rawData.length];
        System.arraycopy(builder.rawData, 0, this.rawData, 0, builder.rawData.length);
    }

    @Override
    public TcpOptionKind getKind() {
        return this.kind;
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] copy = new byte[this.rawData.length];
        System.arraycopy(this.rawData, 0, copy, 0, copy.length);
        return copy;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Kind: ").append(this.kind).append("] [Illegal Raw Data: 0x").append(ByteArrays.toHexString(this.rawData, "")).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return Arrays.equals(((IllegalTcpOption)this.getClass().cast(obj)).getRawData(), this.getRawData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getRawData());
    }

    public static final class Builder {
        private TcpOptionKind kind;
        private byte[] rawData;

        public Builder() {
        }

        private Builder(IllegalTcpOption option) {
            this.kind = option.kind;
            this.rawData = option.rawData;
        }

        public Builder kind(TcpOptionKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder rawData(byte[] rawData) {
            this.rawData = rawData;
            return this;
        }

        public IllegalTcpOption build() {
            return new IllegalTcpOption(this);
        }
    }
}

