/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV6InvokingPacketPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6DestinationUnreachablePacket
extends IcmpV6InvokingPacketPacket {
    private static final long serialVersionUID = -7542312889671819449L;
    private final IcmpV6DestinationUnreachableHeader header;

    public static IcmpV6DestinationUnreachablePacket newPacket(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        IcmpV6DestinationUnreachableHeader header = new IcmpV6DestinationUnreachableHeader(rawData);
        int payloadLength = rawData.length - header.length();
        if (payloadLength > 0) {
            byte[] rawPayload = ByteArrays.getSubArray(rawData, header.length(), payloadLength);
            return new IcmpV6DestinationUnreachablePacket(header, rawPayload);
        }
        return new IcmpV6DestinationUnreachablePacket(header);
    }

    private IcmpV6DestinationUnreachablePacket(IcmpV6DestinationUnreachableHeader header) {
        this.header = header;
    }

    private IcmpV6DestinationUnreachablePacket(IcmpV6DestinationUnreachableHeader header, byte[] rawPayload) {
        super(rawPayload);
        this.header = header;
    }

    private IcmpV6DestinationUnreachablePacket(Builder builder) {
        super(builder);
        this.header = new IcmpV6DestinationUnreachableHeader(builder);
    }

    @Override
    public IcmpV6DestinationUnreachableHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV6DestinationUnreachableHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -1783685027034916291L;
        private static final int UNUSED_OFFSET = 0;
        private static final int UNUSED_SIZE = 4;
        private static final int ICMPV6_DESTINATION_UNREACHABLE_HEADER_SIZE = 4;
        private final int unused;

        private IcmpV6DestinationUnreachableHeader(byte[] rawData) throws IllegalRawDataException {
            if (rawData.length < 4) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an ICMPv6 Destination Unreachable Header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " "));
                throw new IllegalRawDataException(sb.toString());
            }
            this.unused = ByteArrays.getInt(rawData, 0);
        }

        private IcmpV6DestinationUnreachableHeader(Builder builder) {
            this.unused = builder.unused;
        }

        public int getUnused() {
            return this.unused;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.unused));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ICMPv6 Destination Unreachable Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Unused: ").append(this.unused).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends IcmpV6InvokingPacketPacket.Builder {
        private int unused;

        public Builder() {
        }

        private Builder(IcmpV6DestinationUnreachablePacket packet) {
            super(packet);
            this.unused = packet.getHeader().unused;
        }

        public Builder unused(int unused) {
            this.unused = unused;
            return this;
        }

        @Override
        public Builder payload(Packet payload) {
            super.payload(payload);
            return this;
        }

        @Override
        public IcmpV6DestinationUnreachablePacket build() {
            return new IcmpV6DestinationUnreachablePacket(this);
        }
    }
}

