/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.namednumber.Ssh2MessageNumber;

public final class Ssh2NewKeysPacket
extends AbstractPacket {
    private static final long serialVersionUID = -4355029035065046101L;
    private static final Ssh2NewKeysPacket INSTANCE = new Ssh2NewKeysPacket();
    private final Ssh2NewKeysHeader header = Ssh2NewKeysHeader.access$000();

    private Ssh2NewKeysPacket() {
    }

    public static Ssh2NewKeysPacket getInstance() {
        return INSTANCE;
    }

    public static Ssh2NewKeysPacket newPacket(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        Ssh2NewKeysHeader.checkRawData(rawData);
        return INSTANCE;
    }

    @Override
    public Ssh2NewKeysHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet.Builder getBuilder() {
        throw new UnsupportedOperationException();
    }

    public static final class Ssh2NewKeysHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -6964593795610286838L;
        private static final Ssh2NewKeysHeader INSTANCE = new Ssh2NewKeysHeader();
        private final Ssh2MessageNumber messageNumber = Ssh2MessageNumber.SSH_MSG_NEWKEYS;

        private Ssh2NewKeysHeader() {
        }

        private static void checkRawData(byte[] rawData) throws IllegalRawDataException {
            if (rawData.length < 1) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data is too short to build an SSH2 New Keys header. data: ").append(new String(rawData));
                throw new IllegalRawDataException(sb.toString());
            }
            if (!Ssh2MessageNumber.getInstance(rawData[0]).equals(Ssh2MessageNumber.SSH_MSG_KEXINIT)) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data is not an SSH2 New Keys message. data: ").append(new String(rawData));
                throw new IllegalRawDataException(sb.toString());
            }
        }

        private static Ssh2NewKeysHeader getInstance() {
            return INSTANCE;
        }

        public Ssh2MessageNumber getMessageNumber() {
            return this.messageNumber;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(new byte[]{(Byte)this.messageNumber.value()});
            return rawFields;
        }

        @Override
        public int length() {
            return 1;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[SSH2 New Keys Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Message Number: ").append(this.messageNumber).append(ls);
            return sb.toString();
        }

        static /* synthetic */ Ssh2NewKeysHeader access$000() {
            return Ssh2NewKeysHeader.getInstance();
        }
    }
}

