/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.EOFException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NativeMappings;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapDumper;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.PcapStat;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.util.ByteArrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PcapHandle {
    private static final Logger logger = LoggerFactory.getLogger(PcapHandle.class);
    private volatile DataLinkType dlt;
    private final Pointer handle;
    private final Object thisLock = new Object();
    private final ThreadLocal<Long> timestampsInts = new ThreadLocal();
    private final ThreadLocal<Integer> timestampsMicros = new ThreadLocal();
    private volatile boolean open = true;
    private volatile String filteringExpression = "";
    private static final Inet4Address WILDCARD_MASK;

    PcapHandle(Pointer handle) {
        this.handle = handle;
        this.dlt = this.getDltByNative();
    }

    private PcapHandle(Builder builder) throws PcapNativeException {
        int rc;
        NativeMappings.PcapErrbuf errbuf = new NativeMappings.PcapErrbuf();
        this.handle = NativeMappings.pcap_create(builder.deviceName, errbuf);
        if (this.handle == null || errbuf.length() != 0) {
            throw new PcapNativeException(errbuf.toString());
        }
        if (builder.isSnaplenSet && (rc = NativeMappings.pcap_set_snaplen(this.handle, builder.snaplen)) != 0) {
            throw new PcapNativeException(this.getError(), rc);
        }
        if (builder.promiscuousMode != null && (rc = NativeMappings.pcap_set_promisc(this.handle, builder.promiscuousMode.getValue())) != 0) {
            throw new PcapNativeException(this.getError(), rc);
        }
        if (builder.isRfmonSet) {
            try {
                rc = NativeMappings.PcapLibrary.INSTANCE.pcap_set_rfmon(this.handle, builder.rfmon ? 1 : 0);
                if (rc != 0) {
                    throw new PcapNativeException(this.getError(), rc);
                }
            }
            catch (UnsatisfiedLinkError e) {
                logger.error("Failed to instantiate PcapHandle object.", (Throwable)e);
                throw new PcapNativeException("Monitor mode is not supported on this platform.");
            }
        }
        if (builder.isTimeoutMillisSet && (rc = NativeMappings.pcap_set_timeout(this.handle, builder.timeoutMillis)) != 0) {
            throw new PcapNativeException(this.getError(), rc);
        }
        if (builder.isBufferSizeSet && (rc = NativeMappings.pcap_set_buffer_size(this.handle, builder.bufferSize)) != 0) {
            throw new PcapNativeException(this.getError(), rc);
        }
        rc = NativeMappings.pcap_activate(this.handle);
        if (rc < 0) {
            throw new PcapNativeException(this.getError(), rc);
        }
        this.dlt = this.getDltByNative();
    }

    DataLinkType getDltByNative() {
        return DataLinkType.getInstance(NativeMappings.pcap_datalink(this.handle));
    }

    public DataLinkType getDlt() {
        return this.dlt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDlt(DataLinkType dlt) throws PcapNativeException, NotOpenException {
        if (dlt == null) {
            throw new NullPointerException("dlt must not be null.");
        }
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            int rc = NativeMappings.pcap_set_datalink(this.handle, (Integer)dlt.value());
            if (rc < 0) {
                throw new PcapNativeException(this.getError(), rc);
            }
            this.dlt = dlt;
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public String getFilteringExpression() {
        return this.filteringExpression;
    }

    public Long getTimestampInts() {
        return this.timestampsInts.get();
    }

    public Integer getTimestampMicros() {
        return this.timestampsMicros.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSnapshot() throws NotOpenException {
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            return NativeMappings.pcap_snapshot(this.handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwappedType isSwapped() throws NotOpenException {
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            int rc = NativeMappings.pcap_is_swapped(this.handle);
            switch (rc) {
                case 0: {
                    return SwappedType.NOT_SWAPPED;
                }
                case 1: {
                    return SwappedType.SWAPPED;
                }
                case 2: {
                    return SwappedType.MAYBE_SWAPPED;
                }
            }
            logger.warn("pcap_snapshot returned an unexpected code: " + rc);
            return SwappedType.MAYBE_SWAPPED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMajorVersion() throws NotOpenException {
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            return NativeMappings.pcap_major_version(this.handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinorVersion() throws NotOpenException {
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            return NativeMappings.pcap_minor_version(this.handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BpfProgram compileFilter(String bpfExpression, BpfProgram.BpfCompileMode mode, Inet4Address netmask) throws PcapNativeException, NotOpenException {
        int rc;
        if (bpfExpression == null || mode == null || netmask == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("bpfExpression: ").append(bpfExpression).append(" mode: ").append((Object)mode).append(" netmask: ").append(netmask);
            throw new NullPointerException(sb.toString());
        }
        NativeMappings.bpf_program prog = new NativeMappings.bpf_program();
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            rc = NativeMappings.pcap_compile(this.handle, prog, bpfExpression, mode.getValue(), ByteArrays.getInt(ByteArrays.toByteArray(netmask), 0));
        }
        if (rc < 0) {
            throw new PcapNativeException(this.getError(), rc);
        }
        return new BpfProgram(prog, bpfExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(String bpfExpression, BpfProgram.BpfCompileMode mode, Inet4Address netmask) throws PcapNativeException, NotOpenException {
        if (bpfExpression == null || mode == null || netmask == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("bpfExpression: ").append(bpfExpression).append(" mode: ").append((Object)mode).append(" netmask: ").append(netmask);
            throw new NullPointerException(sb.toString());
        }
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            int mask = ByteArrays.getInt(ByteArrays.toByteArray(netmask), 0);
            NativeMappings.bpf_program prog = new NativeMappings.bpf_program();
            try {
                int rc = NativeMappings.pcap_compile(this.handle, prog, bpfExpression, mode.getValue(), mask);
                if (rc < 0) {
                    throw new PcapNativeException("Error occured in pcap_compile: " + this.getError(), rc);
                }
                rc = NativeMappings.pcap_setfilter(this.handle, prog);
                if (rc < 0) {
                    throw new PcapNativeException("Error occured in pcap_setfilger: " + this.getError(), rc);
                }
                this.filteringExpression = bpfExpression;
            }
            finally {
                NativeMappings.pcap_freecode(prog);
            }
        }
    }

    public void setFilter(String bpfExpression, BpfProgram.BpfCompileMode mode) throws PcapNativeException, NotOpenException {
        this.setFilter(bpfExpression, mode, WILDCARD_MASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(BpfProgram prog) throws PcapNativeException, NotOpenException {
        if (prog == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("prog: ").append(prog);
            throw new NullPointerException(sb.toString());
        }
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            int rc = NativeMappings.pcap_setfilter(this.handle, prog.getProgram());
            if (rc < 0) {
                throw new PcapNativeException("Failed to set filter: " + this.getError(), rc);
            }
            this.filteringExpression = prog.getExpression();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockingMode(BlockingMode mode) throws PcapNativeException, NotOpenException {
        int rc;
        if (mode == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(" mode: ").append((Object)mode);
            throw new NullPointerException(sb.toString());
        }
        NativeMappings.PcapErrbuf errbuf = new NativeMappings.PcapErrbuf();
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            rc = NativeMappings.pcap_setnonblock(this.handle, mode.getValue(), errbuf);
        }
        if (rc < 0) {
            throw new PcapNativeException(errbuf.toString(), rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockingMode getBlockingMode() throws PcapNativeException, NotOpenException {
        int rc;
        NativeMappings.PcapErrbuf errbuf = new NativeMappings.PcapErrbuf();
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            rc = NativeMappings.pcap_getnonblock(this.handle, errbuf);
        }
        if (rc == 0) {
            return BlockingMode.BLOCKING;
        }
        if (rc > 0) {
            return BlockingMode.NONBLOCKING;
        }
        throw new PcapNativeException(errbuf.toString(), rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet getNextPacket() throws NotOpenException {
        Pointer packet;
        NativeMappings.pcap_pkthdr header = new NativeMappings.pcap_pkthdr();
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            packet = NativeMappings.pcap_next(this.handle, header);
        }
        if (packet != null) {
            this.timestampsInts.set(header.ts.tv_sec.longValue());
            this.timestampsMicros.set(header.ts.tv_usec.intValue());
            return PacketFactories.getFactory(Packet.class, DataLinkType.class).newInstance(packet.getByteArray(0L, header.caplen), this.dlt);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet getNextPacketEx() throws PcapNativeException, EOFException, TimeoutException, NotOpenException {
        int rc;
        PointerByReference headerPP = new PointerByReference();
        PointerByReference dataPP = new PointerByReference();
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            rc = NativeMappings.pcap_next_ex(this.handle, headerPP, dataPP);
        }
        switch (rc) {
            case 0: {
                throw new TimeoutException();
            }
            case 1: {
                Pointer headerP = headerPP.getValue();
                Pointer dataP = dataPP.getValue();
                if (headerP == null || dataP == null) {
                    throw new PcapNativeException("Failed to get packet. *header: " + headerP + " *data: " + dataP);
                }
                NativeMappings.pcap_pkthdr header = new NativeMappings.pcap_pkthdr(headerP);
                this.timestampsInts.set(header.ts.tv_sec.longValue());
                this.timestampsMicros.set(header.ts.tv_usec.intValue());
                return PacketFactories.getFactory(Packet.class, DataLinkType.class).newInstance(dataP.getByteArray(0L, header.caplen), this.dlt);
            }
            case -1: {
                throw new PcapNativeException("Error occured in pcap_next_ex(): " + this.getError(), rc);
            }
            case -2: {
                throw new EOFException();
            }
        }
        throw new PcapNativeException("Unexpected error occured: " + this.getError(), rc);
    }

    public void loop(int packetCount, PacketListener listener) throws PcapNativeException, InterruptedException, NotOpenException {
        this.loop(packetCount, listener, SimpleExecutor.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loop(int packetCount, PacketListener listener, Executor executor) throws PcapNativeException, InterruptedException, NotOpenException {
        int rc;
        if (listener == null || executor == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("listener: ").append(listener).append(" executor: ").append(executor);
            throw new NullPointerException(sb.toString());
        }
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            logger.info("Start loop");
            rc = NativeMappings.pcap_loop(this.handle, packetCount, new GotPacketFuncExecutor(listener, this.dlt, executor), null);
        }
        switch (rc) {
            case 0: {
                logger.info("Finish loop.");
                break;
            }
            case -1: {
                throw new PcapNativeException("Error occured: " + this.getError(), rc);
            }
            case -2: {
                logger.info("Broken.");
                throw new InterruptedException();
            }
            default: {
                throw new PcapNativeException("Unexpected error occured: " + this.getError(), rc);
            }
        }
    }

    public int dispatch(int packetCount, PacketListener listener) throws PcapNativeException, InterruptedException, NotOpenException {
        return this.dispatch(packetCount, listener, SimpleExecutor.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dispatch(int packetCount, PacketListener listener, Executor executor) throws PcapNativeException, InterruptedException, NotOpenException {
        int rc;
        if (listener == null || executor == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("listener: ").append(listener).append(" executor: ").append(executor);
            throw new NullPointerException(sb.toString());
        }
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            logger.info("Start dispatch");
            rc = NativeMappings.pcap_dispatch(this.handle, packetCount, new GotPacketFuncExecutor(listener, this.dlt, executor), null);
        }
        if (rc < 0) {
            switch (rc) {
                case -1: {
                    throw new PcapNativeException("Error occured: " + this.getError(), rc);
                }
                case -2: {
                    logger.info("Broken.");
                    throw new InterruptedException();
                }
            }
            throw new PcapNativeException("Unexpected error occured: " + this.getError(), rc);
        }
        logger.info("Finish dispatch.");
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PcapDumper dumpOpen(String filePath) throws PcapNativeException {
        Pointer dumper;
        if (filePath == null) {
            throw new NullPointerException("filePath must not be null.");
        }
        Object object = this.thisLock;
        synchronized (object) {
            dumper = NativeMappings.pcap_dump_open(this.handle, filePath);
            if (dumper == null) {
                throw new PcapNativeException(this.getError());
            }
        }
        return new PcapDumper(dumper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loop(int packetCount, PcapDumper dumper) throws PcapNativeException, InterruptedException, NotOpenException {
        int rc;
        if (dumper == null) {
            throw new NullPointerException("dumper must not be null.");
        }
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            logger.info("Start dump loop");
            rc = NativeMappings.pcap_loop(this.handle, packetCount, NativeMappings.PCAP_DUMP, dumper.getDumper());
        }
        switch (rc) {
            case 0: {
                logger.info("Finish dump loop.");
                break;
            }
            case -1: {
                throw new PcapNativeException("Error occured: " + this.getError(), rc);
            }
            case -2: {
                logger.info("Broken.");
                throw new InterruptedException();
            }
            default: {
                throw new PcapNativeException("Unexpected error occured: " + this.getError(), rc);
            }
        }
    }

    public void breakLoop() {
        logger.info("Break loop.");
        NativeMappings.pcap_breakloop(this.handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) throws PcapNativeException, NotOpenException {
        int rc;
        if (packet == null) {
            throw new NullPointerException("packet may not be null");
        }
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            rc = NativeMappings.pcap_sendpacket(this.handle, packet.getRawData(), packet.length());
        }
        if (rc < 0) {
            throw new PcapNativeException("Error occured in pcap_sendpacket(): " + this.getError(), rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                logger.warn("Already closed.");
                return;
            }
            NativeMappings.pcap_close(this.handle);
            this.open = false;
        }
        logger.info("Closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PcapStat getStat() throws PcapNativeException, NotOpenException {
        int rc;
        NativeMappings.pcap_stat ps = Platform.isWindows() ? new NativeMappings.win_pcap_stat() : new NativeMappings.pcap_stat();
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            rc = NativeMappings.pcap_stats(this.handle, ps);
        }
        if (rc < 0) {
            throw new PcapNativeException(this.getError(), rc);
        }
        return new PcapStat(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataLinkType> listDatalinks() throws PcapNativeException, NotOpenException {
        int rc;
        PointerByReference dltBufPP = new PointerByReference();
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            rc = NativeMappings.pcap_list_datalinks(this.handle, dltBufPP);
        }
        if (rc < 0) {
            throw new PcapNativeException(this.getError(), rc);
        }
        Pointer dltBufP = dltBufPP.getValue();
        ArrayList<DataLinkType> list = new ArrayList<DataLinkType>(rc);
        for (int i = 0; i < rc; ++i) {
            list.add(DataLinkType.getInstance(dltBufP.getInt((long)(Pointer.SIZE * i))));
        }
        NativeMappings.pcap_free_datalinks(dltBufP);
        return list;
    }

    public String getError() {
        return NativeMappings.pcap_geterr(this.handle).getString(0L);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        sb.append("Link type: [").append(this.dlt).append("] handle: [").append(this.handle).append("] Open: [").append(this.open).append("] Filtering Expression: [").append(this.filteringExpression).append("]");
        return sb.toString();
    }

    static {
        try {
            WILDCARD_MASK = (Inet4Address)InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)"never get here");
        }
    }

    public static final class Builder {
        private final String deviceName;
        private int snaplen;
        private boolean isSnaplenSet = false;
        private PcapNetworkInterface.PromiscuousMode promiscuousMode = null;
        private boolean rfmon;
        private boolean isRfmonSet = false;
        private int timeoutMillis;
        private boolean isTimeoutMillisSet = false;
        private int bufferSize;
        private boolean isBufferSizeSet = false;

        public Builder(String deviceName) {
            if (deviceName == null || deviceName.length() == 0) {
                throw new IllegalArgumentException("deviceName: " + deviceName);
            }
            this.deviceName = deviceName;
        }

        public Builder snaplen(int snaplen) {
            this.snaplen = snaplen;
            this.isSnaplenSet = true;
            return this;
        }

        public Builder promiscuousMode(PcapNetworkInterface.PromiscuousMode promiscuousMode) {
            this.promiscuousMode = promiscuousMode;
            return this;
        }

        public Builder rfmon(boolean rfmon) {
            this.rfmon = rfmon;
            this.isRfmonSet = true;
            return this;
        }

        public Builder timeoutMillis(int timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            this.isTimeoutMillisSet = true;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            this.isBufferSizeSet = true;
            return this;
        }

        public PcapHandle build() throws PcapNativeException {
            return new PcapHandle(this);
        }
    }

    private final class GotPacketFuncExecutor
    implements NativeMappings.pcap_handler {
        private final DataLinkType dlt;
        private final PacketListener listener;
        private final Executor executor;

        public GotPacketFuncExecutor(PacketListener listener, DataLinkType dlt, Executor executor) {
            this.dlt = dlt;
            this.listener = listener;
            this.executor = executor;
        }

        @Override
        public void got_packet(Pointer args, NativeMappings.pcap_pkthdr header, Pointer packet) {
            final long tvs = header.ts.tv_sec.longValue();
            final int tvus = header.ts.tv_usec.intValue();
            final byte[] ba = packet.getByteArray(0L, header.caplen);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    PcapHandle.this.timestampsInts.set(tvs);
                    PcapHandle.this.timestampsMicros.set(tvus);
                    GotPacketFuncExecutor.this.listener.gotPacket(PacketFactories.getFactory(Packet.class, DataLinkType.class).newInstance(ba, GotPacketFuncExecutor.this.dlt));
                }
            });
        }
    }

    private static final class SimpleExecutor
    implements Executor {
        private static final SimpleExecutor INSTANCE = new SimpleExecutor();

        private SimpleExecutor() {
        }

        public static SimpleExecutor getInstance() {
            return INSTANCE;
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    public static enum BlockingMode {
        BLOCKING(0),
        NONBLOCKING(1);

        private final int value;

        private BlockingMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum SwappedType {
        NOT_SWAPPED(0),
        SWAPPED(1),
        MAYBE_SWAPPED(2);

        private final int value;

        private SwappedType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

