/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IpV4OptionType
extends NamedNumber<Byte> {
    private static final long serialVersionUID = -7033971699970069137L;
    public static final IpV4OptionType END_OF_OPTION_LIST = new IpV4OptionType((byte)0, "End of Option List");
    public static final IpV4OptionType NO_OPERATION = new IpV4OptionType((byte)1, "No Operation");
    public static final IpV4OptionType SECURITY = new IpV4OptionType((byte)-126, "Security");
    public static final IpV4OptionType LOOSE_SOURCE_ROUTING = new IpV4OptionType((byte)-125, "Loose Source Routing");
    public static final IpV4OptionType INTERNET_TIMESTAMP = new IpV4OptionType((byte)68, "Internet Timestamp");
    public static final IpV4OptionType RECORD_ROUTE = new IpV4OptionType((byte)7, "Record Route");
    public static final IpV4OptionType STREAM_ID = new IpV4OptionType((byte)-120, "Stream ID");
    public static final IpV4OptionType STRICT_SOURCE_ROUTING = new IpV4OptionType((byte)-119, "Strict Source Routing");
    private static final Map<Byte, IpV4OptionType> registry = new HashMap<Byte, IpV4OptionType>();
    private final boolean copied;
    private final IpV4OptionClass optionClass;
    private final byte number;

    public IpV4OptionType(Byte value, String name) {
        super(value, name);
        this.copied = (value & 0x80) != 0;
        this.number = (byte)(value & 0x1F);
        switch (value & 0x60) {
            case 0: {
                this.optionClass = IpV4OptionClass.CONTROL;
                break;
            }
            case 32: {
                this.optionClass = IpV4OptionClass.RESERVED_FOR_FUTURE_USE1;
                break;
            }
            case 64: {
                this.optionClass = IpV4OptionClass.DEBUGGING_AND_MEASUREMENT;
                break;
            }
            case 96: {
                this.optionClass = IpV4OptionClass.RESERVED_FOR_FUTURE_USE3;
                break;
            }
            default: {
                throw new AssertionError((Object)"Never get here");
            }
        }
    }

    public boolean isCopied() {
        return this.copied;
    }

    public IpV4OptionClass getOptionClass() {
        return this.optionClass;
    }

    public byte getNumber() {
        return this.number;
    }

    public static IpV4OptionType getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new IpV4OptionType(value, "unknown");
    }

    public static IpV4OptionType register(IpV4OptionType type) {
        return registry.put((Byte)type.value(), type);
    }

    @Override
    public int compareTo(Byte o) {
        return ((Byte)this.value()).compareTo(o);
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    static {
        for (Field field : IpV4OptionType.class.getFields()) {
            if (!IpV4OptionType.class.isAssignableFrom(field.getType())) continue;
            try {
                IpV4OptionType f = (IpV4OptionType)field.get(null);
                registry.put((Byte)f.value(), f);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IpV4OptionClass {
        CONTROL(0),
        RESERVED_FOR_FUTURE_USE1(1),
        DEBUGGING_AND_MEASUREMENT(2),
        RESERVED_FOR_FUTURE_USE3(3);

        private final byte value;

        private IpV4OptionClass(byte value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

