/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;
import org.pcap4j.util.ByteArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EtherType
extends NamedNumber<Short> {
    private static final long serialVersionUID = 7866667243677334444L;
    public static final EtherType IPV4 = new EtherType((short)2048, "IPv4");
    public static final EtherType ARP = new EtherType((short)2054, "ARP");
    public static final EtherType DOT1Q_VLAN_TAGGED_FRAMES = new EtherType((short)-32512, "IEEE 802.1Q VLAN-tagged frames");
    public static final EtherType RARP = new EtherType((short)-32715, "RARP");
    public static final EtherType APPLETALK = new EtherType((short)-32613, "Appletalk");
    public static final EtherType IPV6 = new EtherType((short)-31011, "IPv6");
    public static final EtherType PPP = new EtherType((short)-30709, "PPP");
    public static final EtherType MPLS = new EtherType((short)-30649, "MPLS");
    public static final EtherType PPPOE_DISCOVERY_STAGE = new EtherType((short)-30621, "PPPoE Discovery Stage");
    public static final EtherType PPPOE_SESSION_STAGE = new EtherType((short)-30620, "PPPoE Session Stage");
    private static final Map<Short, EtherType> registry = new HashMap<Short, EtherType>();

    public EtherType(Short value, String name) {
        super(value, name);
    }

    public static EtherType getInstance(Short value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new EtherType(value, "unknown");
    }

    public static EtherType register(EtherType type) {
        return registry.put((Short)type.value(), type);
    }

    @Override
    public String valueAsString() {
        return "0x" + ByteArrays.toHexString((Short)this.value(), "");
    }

    @Override
    public int compareTo(Short o) {
        return ((Short)this.value()).compareTo(o);
    }

    static {
        for (Field field : EtherType.class.getFields()) {
            if (!EtherType.class.isAssignableFrom(field.getType())) continue;
            try {
                EtherType f = (EtherType)field.get(null);
                registry.put((Short)f.value(), f);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }
}

