/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.ObjectStreamException;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.namednumber.TcpOptionKind;
import org.pcap4j.util.ByteArrays;

public final class TcpEndOfOptionList
implements TcpPacket.TcpOption {
    private static final long serialVersionUID = -4181756738827638374L;
    private static final TcpEndOfOptionList INSTANCE = new TcpEndOfOptionList();
    private static final TcpOptionKind kind = TcpOptionKind.END_OF_OPTION_LIST;

    private TcpEndOfOptionList() {
    }

    public static TcpEndOfOptionList getInstance() {
        return INSTANCE;
    }

    public static TcpEndOfOptionList newInstance(byte[] rawData) {
        if (rawData == null) {
            throw new NullPointerException("rawData may not be null");
        }
        if (rawData.length == 0) {
            throw new IllegalRawDataException("The raw data length must be more than 0");
        }
        if (rawData[0] != (Byte)kind.value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The kind must be: ").append(kind.valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        return INSTANCE;
    }

    public TcpOptionKind getKind() {
        return kind;
    }

    public int length() {
        return 1;
    }

    public byte[] getRawData() {
        return new byte[1];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Kind: ").append(kind);
        sb.append("]");
        return sb.toString();
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

