/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Ssh2MessageNumber;

public final class Ssh2NewKeysPacket
extends AbstractPacket {
    private static final long serialVersionUID = -4355029035065046101L;
    private final Ssh2NewKeysHeader header;

    public static Ssh2NewKeysPacket newPacket(byte[] rawData) {
        return new Ssh2NewKeysPacket(rawData);
    }

    private Ssh2NewKeysPacket(byte[] rawData) {
        if (rawData == null) {
            throw new NullPointerException();
        }
        this.header = new Ssh2NewKeysHeader(rawData);
    }

    private Ssh2NewKeysPacket(Builder builder) {
        if (builder == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder);
            throw new NullPointerException(sb.toString());
        }
        this.header = new Ssh2NewKeysHeader(builder);
    }

    public Ssh2NewKeysHeader getHeader() {
        return this.header;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Ssh2NewKeysHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -6964593795610286838L;
        private final Ssh2MessageNumber messageNumber = Ssh2MessageNumber.SSH_MSG_NEWKEYS;

        private Ssh2NewKeysHeader(byte[] rawData) {
            if (rawData.length < 1) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data is too short to build an SSH2 New Keys header. data: ").append(new String(rawData));
                throw new IllegalRawDataException(sb.toString());
            }
            if (!Ssh2MessageNumber.getInstance(rawData[0]).equals(Ssh2MessageNumber.SSH_MSG_KEXINIT)) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data is not an SSH2 New Keys message. data: ").append(new String(rawData));
                throw new IllegalRawDataException(sb.toString());
            }
        }

        private Ssh2NewKeysHeader(Builder builder) {
        }

        public Ssh2MessageNumber getMessageNumber() {
            return this.messageNumber;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(new byte[]{(Byte)this.messageNumber.value()});
            return rawFields;
        }

        @Override
        public int length() {
            return 1;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[SSH2 New Keys Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Message Number: ").append(this.messageNumber).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        public Builder() {
        }

        private Builder(Ssh2NewKeysPacket packet) {
        }

        public Ssh2NewKeysPacket build() {
            return new Ssh2NewKeysPacket(this);
        }
    }
}

