/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.namednumber.IpV4TosPrecedence;
import org.pcap4j.packet.namednumber.IpV4TosTos;

public final class IpV4Rfc1349Tos
implements IpV4Packet.IpV4Tos {
    private static final long serialVersionUID = 1760697525836662144L;
    private final IpV4TosPrecedence precedence;
    private final IpV4TosTos tos;
    private final boolean mbz;

    public static IpV4Rfc1349Tos newInstance(byte value) {
        return new IpV4Rfc1349Tos(value);
    }

    private IpV4Rfc1349Tos(byte value) {
        this.precedence = IpV4TosPrecedence.getInstance((byte)((value & 0xE0) >> 5));
        this.tos = IpV4TosTos.getInstance((byte)(0xF & value >> 1));
        this.mbz = (value & 1) != 0;
    }

    private IpV4Rfc1349Tos(Builder builder) {
        if (builder == null || builder.precedence == null || builder.tos == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder").append(builder).append(" builder.precedence: ").append(builder.precedence).append(" builder.tos: ").append(builder.tos);
            throw new NullPointerException(sb.toString());
        }
        this.precedence = builder.precedence;
        this.tos = builder.tos;
        this.mbz = builder.mbz;
    }

    public IpV4TosPrecedence getPrecedence() {
        return this.precedence;
    }

    public IpV4TosTos getTos() {
        return this.tos;
    }

    public boolean mbz() {
        return this.mbz;
    }

    public byte value() {
        byte value = (byte)((Byte)this.precedence.value() << 5);
        value = (byte)(value | (Byte)this.tos.value() << 1);
        if (this.mbz) {
            value = (byte)(value | 1);
        }
        return value;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[precedence: ").append(this.precedence).append("] [tos: ").append(this.tos).append("] [mbz: ").append(this.mbz ? 1 : 0).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return ((IpV4Rfc1349Tos)this.getClass().cast(obj)).value() == this.value();
    }

    public int hashCode() {
        return this.value();
    }

    public static final class Builder {
        private IpV4TosPrecedence precedence;
        private IpV4TosTos tos;
        private boolean mbz;

        public Builder() {
        }

        private Builder(IpV4Rfc1349Tos tos) {
            this.precedence = tos.precedence;
            this.tos = tos.tos;
            this.mbz = tos.mbz;
        }

        public Builder precedence(IpV4TosPrecedence precedence) {
            this.precedence = precedence;
            return this;
        }

        public Builder tos(IpV4TosTos tos) {
            this.tos = tos;
            return this;
        }

        public Builder mbz(boolean mbz) {
            this.mbz = mbz;
            return this;
        }

        public IpV4Rfc1349Tos build() {
            return new IpV4Rfc1349Tos(this);
        }
    }
}

