/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IpV6RoutingHeaderType
extends NamedNumber<Byte> {
    private static final long serialVersionUID = -6648259162603151846L;
    public static final IpV6RoutingHeaderType SOURCE_ROUTE = new IpV6RoutingHeaderType((byte)0, "Source Route");
    public static final IpV6RoutingHeaderType TYPE2_ROUTING_HEADER = new IpV6RoutingHeaderType((byte)2, "Type 2 Routing Header");
    public static final IpV6RoutingHeaderType RPL_SOURCE_ROUTE_HEADER = new IpV6RoutingHeaderType((byte)3, "RPL Source Route Header");
    private static final Map<Byte, IpV6RoutingHeaderType> registry = new HashMap<Byte, IpV6RoutingHeaderType>();

    public IpV6RoutingHeaderType(Byte value, String name) {
        super(value, name);
    }

    public static IpV6RoutingHeaderType getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new IpV6RoutingHeaderType(value, "unknown");
    }

    public static IpV6RoutingHeaderType register(IpV6RoutingHeaderType number) {
        return registry.put((Byte)number.value(), number);
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    @Override
    public int compareTo(Byte o) {
        return ((Byte)this.value()).compareTo(o);
    }

    static {
        for (Field field : IpV6RoutingHeaderType.class.getFields()) {
            if (!IpV6RoutingHeaderType.class.isAssignableFrom(field.getType())) continue;
            try {
                IpV6RoutingHeaderType f = (IpV6RoutingHeaderType)field.get(null);
                registry.put((Byte)f.value(), f);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }
}

