/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IpV6OptionType
extends NamedNumber<Byte> {
    private static final long serialVersionUID = -5043412814955401877L;
    public static final IpV6OptionType PAD1 = new IpV6OptionType((byte)0, "Pad1");
    public static final IpV6OptionType PADN = new IpV6OptionType((byte)1, "PadN");
    private static final Map<Byte, IpV6OptionType> registry = new HashMap<Byte, IpV6OptionType>();
    private final IpV6OptionTypeIdentifier identifier;

    public IpV6OptionType(Byte value, String name) {
        super(value, name);
        switch (value & 0xC0) {
            case 0: {
                this.identifier = IpV6OptionTypeIdentifier.SKIP;
                break;
            }
            case 64: {
                this.identifier = IpV6OptionTypeIdentifier.DISCARD;
                break;
            }
            case 128: {
                this.identifier = IpV6OptionTypeIdentifier.DISCARD_AND_SEND_ICMP;
                break;
            }
            case 192: {
                this.identifier = IpV6OptionTypeIdentifier.DISCARD_AND_SEND_ICMP_IF_NOT_MULTICAST;
                break;
            }
            default: {
                throw new AssertionError((Object)"Never get here");
            }
        }
    }

    public static IpV6OptionType getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new IpV6OptionType(value, "unknown");
    }

    public static IpV6OptionType register(IpV6OptionType type) {
        return registry.put((Byte)type.value(), type);
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    @Override
    public int compareTo(Byte o) {
        return ((Byte)this.value()).compareTo(o);
    }

    public IpV6OptionTypeIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean optionDataIsChangable() {
        return ((Byte)this.value() & 0x20) != 0;
    }

    static {
        for (Field field : IpV6OptionType.class.getFields()) {
            if (!IpV6OptionType.class.isAssignableFrom(field.getType())) continue;
            try {
                IpV6OptionType f = (IpV6OptionType)field.get(null);
                registry.put((Byte)f.value(), f);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IpV6OptionTypeIdentifier {
        SKIP(0),
        DISCARD(1),
        DISCARD_AND_SEND_ICMP(2),
        DISCARD_AND_SEND_ICMP_IF_NOT_MULTICAST(3);

        private final byte value;

        private IpV6OptionTypeIdentifier(byte value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

