/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4InternetTimestampOption;
import org.pcap4j.util.ByteArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IpV4InternetTimestampOptionTimestamps
implements IpV4InternetTimestampOption.IpV4InternetTimestampOptionData {
    private static final long serialVersionUID = -2067863811913941432L;
    private final List<Integer> timestamps;

    public static IpV4InternetTimestampOptionTimestamps newInstance(byte[] rawData) {
        return new IpV4InternetTimestampOptionTimestamps(rawData);
    }

    private IpV4InternetTimestampOptionTimestamps(byte[] rawData) {
        if (rawData == null) {
            throw new NullPointerException("rawData may not be null");
        }
        if (rawData.length % 4 != 0) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data length must be an integer multiple of 4 octets long. rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        this.timestamps = new ArrayList<Integer>();
        for (int i = 0; i < rawData.length; i += 4) {
            this.timestamps.add(ByteArrays.getInt(rawData, i));
        }
    }

    public IpV4InternetTimestampOptionTimestamps(List<Integer> timestamps) {
        if (timestamps == null) {
            throw new NullPointerException("timestamps may not be null");
        }
        this.timestamps = new ArrayList<Integer>(timestamps);
    }

    public List<Integer> getTimestamps() {
        return new ArrayList<Integer>(this.timestamps);
    }

    @Override
    public int length() {
        return this.timestamps.size() * 4;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        Iterator<Integer> iter = this.timestamps.iterator();
        for (int i = 0; i < rawData.length; i += 4) {
            System.arraycopy(ByteArrays.toByteArray(iter.next()), 0, rawData, 0, 4);
        }
        return rawData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[timestamps:");
        for (Integer ts : this.timestamps) {
            sb.append(" ").append((long)ts.intValue() & 0xFFFFFFFFL);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return Arrays.equals(((IpV4InternetTimestampOptionTimestamps)this.getClass().cast(obj)).getRawData(), this.getRawData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getRawData());
    }
}

