/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV6InvokingPacketPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6TimeExceededPacket
extends IcmpV6InvokingPacketPacket {
    private static final long serialVersionUID = 548806622487019458L;
    private final IcmpV6TimeExceededHeader header;

    public static IcmpV6TimeExceededPacket newPacket(byte[] rawData) {
        IcmpV6TimeExceededHeader header = new IcmpV6TimeExceededHeader(rawData);
        byte[] rawPayload = ByteArrays.getSubArray(rawData, header.length(), rawData.length - header.length());
        return new IcmpV6TimeExceededPacket(header, rawPayload);
    }

    private IcmpV6TimeExceededPacket(IcmpV6TimeExceededHeader header, byte[] rawData) {
        super(rawData);
        this.header = header;
    }

    private IcmpV6TimeExceededPacket(Builder builder) {
        super(builder);
        this.header = new IcmpV6TimeExceededHeader(builder);
    }

    public IcmpV6TimeExceededHeader getHeader() {
        return this.header;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IcmpV6TimeExceededHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 7744561095455514341L;
        private static final int UNUSED_OFFSET = 0;
        private static final int UNUSED_SIZE = 4;
        private static final int ICMPV6_TIME_EXCEEDED_HEADER_SIZE = 4;
        private final int unused;

        private IcmpV6TimeExceededHeader(byte[] rawData) {
            if (rawData.length < 4) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an ICMPv6 Time Exceeded Header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " "));
                throw new IllegalRawDataException(sb.toString());
            }
            this.unused = ByteArrays.getInt(rawData, 0);
        }

        private IcmpV6TimeExceededHeader(Builder builder) {
            this.unused = builder.unused;
        }

        public int getUnused() {
            return this.unused;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.unused));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ICMPv6 Time Exceeded Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Unused: ").append(this.unused).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends IcmpV6InvokingPacketPacket.Builder {
        private int unused;

        public Builder() {
        }

        private Builder(IcmpV6TimeExceededPacket packet) {
            super(packet);
            this.unused = packet.getHeader().unused;
        }

        public Builder unused(int unused) {
            this.unused = unused;
            return this;
        }

        public Builder payload(Packet payload) {
            super.payload(payload);
            return this;
        }

        public IcmpV6TimeExceededPacket build() {
            return new IcmpV6TimeExceededPacket(this);
        }
    }
}

