/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet6Address;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.IpV6NeighborDiscoveryOptionType;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6NeighborAdvertisementPacket
extends AbstractPacket {
    private static final long serialVersionUID = 2928161747361401145L;
    private final IcmpV6NeighborAdvertisementHeader header;

    public static IcmpV6NeighborAdvertisementPacket newPacket(byte[] rawData) {
        return new IcmpV6NeighborAdvertisementPacket(rawData);
    }

    private IcmpV6NeighborAdvertisementPacket(byte[] rawData) {
        this.header = new IcmpV6NeighborAdvertisementHeader(rawData);
    }

    private IcmpV6NeighborAdvertisementPacket(Builder builder) {
        if (builder == null || builder.targetAddress == null || builder.options == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.targetAddress: ").append(builder.targetAddress).append(" builder.options: ").append(builder.options);
            throw new NullPointerException(sb.toString());
        }
        this.header = new IcmpV6NeighborAdvertisementHeader(builder);
    }

    public IcmpV6NeighborAdvertisementHeader getHeader() {
        return this.header;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IcmpV6NeighborAdvertisementHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 2755611686067943647L;
        private static final int R_S_O_RESERVED_OFFSET = 0;
        private static final int R_S_O_RESERVED_SIZE = 4;
        private static final int TARGET_ADDRESS_OFFSET = 4;
        private static final int TARGET_ADDRESS_SIZE = 16;
        private static final int OPTIONS_OFFSET = 20;
        private final boolean routerFlag;
        private final boolean solicitedFlag;
        private final boolean overrideFlag;
        private final int reserved;
        private final Inet6Address targetAddress;
        private final List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options;

        private IcmpV6NeighborAdvertisementHeader(byte[] rawData) {
            IcmpV6CommonPacket.IpV6NeighborDiscoveryOption newOne;
            if (rawData.length < 20) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The raw data must be more than ").append(19).append("bytes").append(" to build this header. raw data: ").append(ByteArrays.toHexString(rawData, " "));
                throw new IllegalRawDataException(sb.toString());
            }
            int tmp = ByteArrays.getInt(rawData, 0);
            this.routerFlag = (tmp & Integer.MIN_VALUE) != 0;
            this.solicitedFlag = (tmp & 0x40000000) != 0;
            this.overrideFlag = (tmp & 0x20000000) != 0;
            this.reserved = 0x1FFFFFFF & tmp;
            this.targetAddress = ByteArrays.getInet6Address(rawData, 4);
            this.options = new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>();
            for (int currentOffset = 20; currentOffset < rawData.length; currentOffset += newOne.length()) {
                byte[] optRawData = ByteArrays.getSubArray(rawData, currentOffset, rawData.length - currentOffset);
                IpV6NeighborDiscoveryOptionType type = IpV6NeighborDiscoveryOptionType.getInstance(optRawData[0]);
                newOne = PacketFactories.getFactory(IcmpV6CommonPacket.IpV6NeighborDiscoveryOption.class, IpV6NeighborDiscoveryOptionType.class).newInstance(optRawData, type);
                this.options.add(newOne);
            }
        }

        private IcmpV6NeighborAdvertisementHeader(Builder builder) {
            if ((builder.reserved & 0xE0000000) != 0) {
                throw new IllegalArgumentException("Invalid reserved: " + builder.reserved);
            }
            this.routerFlag = builder.routerFlag;
            this.solicitedFlag = builder.solicitedFlag;
            this.overrideFlag = builder.overrideFlag;
            this.reserved = builder.reserved;
            this.targetAddress = builder.targetAddress;
            this.options = new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>(builder.options);
        }

        public boolean getRouterFlag() {
            return this.routerFlag;
        }

        public boolean getSolicitedFlag() {
            return this.solicitedFlag;
        }

        public boolean getOverrideFlag() {
            return this.overrideFlag;
        }

        public int getReserved() {
            return this.reserved;
        }

        public Inet6Address getTargetAddress() {
            return this.targetAddress;
        }

        public List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> getOptions() {
            return new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>(this.options);
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            int tmp = 0x1FFFFFFF & this.reserved;
            if (this.routerFlag) {
                tmp |= Integer.MIN_VALUE;
            }
            if (this.solicitedFlag) {
                tmp |= 0x40000000;
            }
            if (this.overrideFlag) {
                tmp |= 0x20000000;
            }
            rawFields.add(ByteArrays.toByteArray(tmp));
            rawFields.add(ByteArrays.toByteArray(this.targetAddress));
            for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption o : this.options) {
                rawFields.add(o.getRawData());
            }
            return rawFields;
        }

        @Override
        protected int measureLength() {
            int len = 0;
            for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption o : this.options) {
                len += o.length();
            }
            return len + 20;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ICMPv6 Neighbor Advertisement Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Router flag: ").append(this.routerFlag).append(ls);
            sb.append("  Solicited flag: ").append(this.solicitedFlag).append(ls);
            sb.append("  Override flag: ").append(this.overrideFlag).append(ls);
            sb.append("  Reserved: ").append(this.reserved).append(ls);
            sb.append("  Target Address: ").append(this.targetAddress).append(ls);
            for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption opt : this.options) {
                sb.append("  Option: ").append(opt).append(ls);
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private boolean routerFlag;
        private boolean solicitedFlag;
        private boolean overrideFlag;
        private int reserved;
        private Inet6Address targetAddress;
        private List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options;

        public Builder() {
        }

        private Builder(IcmpV6NeighborAdvertisementPacket packet) {
            this.routerFlag = packet.header.routerFlag;
            this.solicitedFlag = packet.header.solicitedFlag;
            this.overrideFlag = packet.header.overrideFlag;
            this.reserved = packet.header.reserved;
            this.targetAddress = packet.header.targetAddress;
            this.options = packet.header.options;
        }

        public Builder routerFlag(boolean routerFlag) {
            this.routerFlag = routerFlag;
            return this;
        }

        public Builder solicitedFlag(boolean solicitedFlag) {
            this.solicitedFlag = solicitedFlag;
            return this;
        }

        public Builder overrideFlag(boolean overrideFlag) {
            this.overrideFlag = overrideFlag;
            return this;
        }

        public Builder reserved(int reserved) {
            this.reserved = reserved;
            return this;
        }

        public Builder targetAddress(Inet6Address targetAddress) {
            this.targetAddress = targetAddress;
            return this;
        }

        public Builder options(List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options) {
            this.options = options;
            return this;
        }

        @Override
        public IcmpV6NeighborAdvertisementPacket build() {
            return new IcmpV6NeighborAdvertisementPacket(this);
        }
    }
}

