/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IcmpIdentifiablePacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6EchoRequestPacket
extends IcmpIdentifiablePacket {
    private static final long serialVersionUID = 1447480467515593011L;
    private final IcmpV6EchoRequestHeader header;
    private final Packet payload;

    public static IcmpV6EchoRequestPacket newPacket(byte[] rawData) {
        return new IcmpV6EchoRequestPacket(rawData);
    }

    private IcmpV6EchoRequestPacket(byte[] rawData) {
        this.header = new IcmpV6EchoRequestHeader(rawData);
        byte[] rawPayload = ByteArrays.getSubArray(rawData, this.header.length(), rawData.length - this.header.length());
        this.payload = UnknownPacket.newPacket(rawPayload);
    }

    private IcmpV6EchoRequestPacket(Builder builder) {
        super(builder);
        if (builder.payloadBuilder == null) {
            throw new NullPointerException("builder.payloadBuilder must not be null");
        }
        this.payload = builder.payloadBuilder.build();
        this.header = new IcmpV6EchoRequestHeader(builder);
    }

    public IcmpV6EchoRequestHeader getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV6EchoRequestHeader
    extends IcmpIdentifiablePacket.IcmpIdentifiableHeader {
        private static final long serialVersionUID = -6510139039546388892L;

        private IcmpV6EchoRequestHeader(byte[] rawData) {
            super(rawData);
        }

        private IcmpV6EchoRequestHeader(Builder builder) {
            super(builder);
        }

        protected String getHeaderName() {
            return "ICMPv6 Echo Request Header";
        }
    }

    public static final class Builder
    extends IcmpIdentifiablePacket.Builder {
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        private Builder(IcmpV6EchoRequestPacket packet) {
            super(packet);
            this.payloadBuilder = packet.payload.getBuilder();
        }

        public Builder identifier(short identifier) {
            super.identifier(identifier);
            return this;
        }

        public Builder sequenceNumber(short sequenceNumber) {
            super.sequenceNumber(sequenceNumber);
            return this;
        }

        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public IcmpV6EchoRequestPacket build() {
            return new IcmpV6EchoRequestPacket(this);
        }
    }
}

