/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV4InvokingPacketPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.ByteArrays;

public final class IcmpV4ParameterProblemPacket
extends IcmpV4InvokingPacketPacket {
    private static final long serialVersionUID = 5369176981310492220L;
    private final IcmpV4ParameterProblemHeader header;

    public static IcmpV4ParameterProblemPacket newPacket(byte[] rawData) {
        IcmpV4ParameterProblemHeader header = new IcmpV4ParameterProblemHeader(rawData);
        byte[] rawPayload = ByteArrays.getSubArray(rawData, header.length(), rawData.length - header.length());
        return new IcmpV4ParameterProblemPacket(header, rawPayload);
    }

    private IcmpV4ParameterProblemPacket(IcmpV4ParameterProblemHeader header, byte[] rawData) {
        super(rawData);
        this.header = header;
    }

    private IcmpV4ParameterProblemPacket(Builder builder) {
        super(builder);
        this.header = new IcmpV4ParameterProblemHeader(builder);
    }

    public IcmpV4ParameterProblemHeader getHeader() {
        return this.header;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IcmpV4ParameterProblemHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 7946304491624744071L;
        private static final int POINTER_AND_UNUSED_OFFSET = 0;
        private static final int POINTER_AND_UNUSED_SIZE = 4;
        private static final int ICMPV4_PARAMETER_PROBLEM_HEADER_SIZE = 4;
        private final byte pointer;
        private final int unused;

        private IcmpV4ParameterProblemHeader(byte[] rawData) {
            if (rawData.length < 4) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an ICMPv4 Parameter Problem Header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " "));
                throw new IllegalRawDataException(sb.toString());
            }
            int pointerAndUnused = ByteArrays.getInt(rawData, 0);
            this.pointer = (byte)(pointerAndUnused >>> 24);
            this.unused = pointerAndUnused & 0xFFFFFF;
        }

        private IcmpV4ParameterProblemHeader(Builder builder) {
            if ((builder.unused & 0xFF000000) != 0) {
                throw new IllegalArgumentException("Invalid unused: " + builder.unused);
            }
            this.pointer = builder.pointer;
            this.unused = builder.unused;
        }

        public byte getPointer() {
            return this.pointer;
        }

        public int getPointerAsInt() {
            return this.pointer & 0xFF;
        }

        public int getUnused() {
            return this.unused;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.pointer << 24 | this.unused));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ICMPv4 Parameter Problem Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Pointer: ").append(this.getPointerAsInt()).append(ls);
            sb.append("  Unused: ").append(this.unused).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends IcmpV4InvokingPacketPacket.Builder {
        private byte pointer;
        private int unused;

        public Builder() {
        }

        private Builder(IcmpV4ParameterProblemPacket packet) {
            super(packet);
            this.pointer = packet.header.pointer;
            this.unused = packet.header.unused;
        }

        public Builder pointer(byte pointer) {
            this.pointer = pointer;
            return this;
        }

        public Builder unused(int unused) {
            this.unused = unused;
            return this;
        }

        public Builder payload(Packet payload) {
            super.payload(payload);
            return this;
        }

        public IcmpV4ParameterProblemPacket build() {
            return new IcmpV4ParameterProblemPacket(this);
        }
    }
}

