/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.core.NativeMappings;
import org.pcap4j.core.PcapAddress;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapIpV4Address;
import org.pcap4j.core.PcapIpV6Address;
import org.pcap4j.core.PcapNativeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PcapNetworkInterface {
    private static final Logger logger = LoggerFactory.getLogger(PcapNetworkInterface.class);
    private static final int PCAP_IF_LOOPBACK = 1;
    private final String name;
    private final String description;
    private final List<PcapAddress> addresses = new ArrayList<PcapAddress>();
    private final boolean loopBack;
    private final boolean local;

    private PcapNetworkInterface(NativeMappings.pcap_if pif, boolean local) {
        this.name = pif.name;
        this.description = pif.description;
        NativeMappings.pcap_addr.ByReference pcapAddr = pif.addresses;
        while (pcapAddr != null) {
            switch (pcapAddr.addr.sa_family) {
                case 2: {
                    this.addresses.add(PcapIpV4Address.newInstance(pcapAddr));
                    break;
                }
                case 23: {
                    this.addresses.add(PcapIpV6Address.newInstance(pcapAddr));
                    break;
                }
                default: {
                    logger.warn("{} is not supported address family. Ignore it.", (Object)pcapAddr.addr.sa_family);
                }
            }
            pcapAddr = pcapAddr.next;
        }
        this.loopBack = pif.flags == 1;
        this.local = local;
    }

    static PcapNetworkInterface newInstance(NativeMappings.pcap_if pif, boolean local) {
        return new PcapNetworkInterface(pif, local);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PcapAddress> getAddresses() {
        return new ArrayList<PcapAddress>(this.addresses);
    }

    public boolean isLoopBack() {
        return this.loopBack;
    }

    public boolean isLocal() {
        return this.local;
    }

    public PcapHandle openLive(int maxCaptureLength, PromiscuousMode mode, int timeoutMillis) throws PcapNativeException {
        if (mode == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("mode: ").append((Object)mode);
            throw new NullPointerException(sb.toString());
        }
        NativeMappings.PcapErrbuf errbuf = new NativeMappings.PcapErrbuf();
        Pointer handle = NativeMappings.pcap_open_live(this.name, maxCaptureLength, mode.getValue(), timeoutMillis, errbuf);
        if (handle == null || errbuf.length() != 0) {
            throw new PcapNativeException(errbuf.toString());
        }
        if (timeoutMillis == 0 && Platform.isSolaris()) {
            NativeMappings.timeval to = new NativeMappings.timeval();
            to.tv_sec = new NativeLong(0L);
            to.tv_usec = new NativeLong(0L);
            int rc = NativeMappings.PcapLibrary.INSTANCE.strioctl(NativeMappings.getFdFromPcapT(handle), 16897, to.size(), to.getPointer());
            if (rc < 0) {
                throw new PcapNativeException("SBIOCSTIME: " + NativeMappings.pcap_strerror(NativeMappings.ERRNO_P.getInt(0L)).getString(0L));
            }
        }
        return new PcapHandle(handle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(250);
        sb.append("name: [").append(this.name).append("] description: [").append(this.description);
        for (PcapAddress addr : this.addresses) {
            sb.append("] address: [").append(addr.getAddress());
        }
        sb.append("] loopBack: [").append(this.loopBack).append("]");
        sb.append("] local: [").append(this.local).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PcapNetworkInterface)) {
            return false;
        }
        PcapNetworkInterface other = (PcapNetworkInterface)obj;
        return this.name.equals(other.getName()) && this.local == other.isLocal();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PromiscuousMode {
        PROMISCUOUS(1),
        NONPROMISCUOUS(0);

        private final int value;

        private PromiscuousMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

