/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import org.pcap4j.core.NativeMappings;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.packet.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PcapDumper {
    private static final Logger logger = LoggerFactory.getLogger(PcapDumper.class);
    private final Pointer dumper;
    private final Object thisLock = new Object();
    private volatile boolean open = true;

    PcapDumper(Pointer dumper) {
        this.dumper = dumper;
    }

    Pointer getDumper() {
        return this.dumper;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void dump(Packet packet) throws NotOpenException {
        long cur = System.currentTimeMillis();
        long timestampSec = cur / 1000L;
        int timestampMicros = (int)((cur - timestampSec * 1000L) * 1000L);
        this.dump(packet, timestampSec, timestampMicros);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Packet packet, long timestampSec, int timestampMicros) throws NotOpenException {
        if (timestampSec < 0L) {
            throw new IllegalArgumentException("timestampSec must be positive: " + timestampSec);
        }
        if (timestampMicros < 0 || timestampMicros >= 1000000) {
            throw new IllegalArgumentException("timestampMicros must be between 0 and 999999: " + timestampMicros);
        }
        if (packet == null) {
            throw new NullPointerException("packet may not be null");
        }
        NativeMappings.pcap_pkthdr header = new NativeMappings.pcap_pkthdr();
        header.len = header.caplen = packet.length();
        header.ts = new NativeMappings.timeval();
        header.ts.tv_sec = new NativeLong(timestampSec);
        header.ts.tv_usec = new NativeLong((long)timestampMicros);
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            NativeMappings.pcap_dump(this.dumper, header, packet.getRawData());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Dumped a packet: " + packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws PcapNativeException, NotOpenException {
        int rc;
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            rc = NativeMappings.pcap_dump_flush(this.dumper);
        }
        if (rc < 0) {
            throw new PcapNativeException("Failed to flush.", rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long ftell() throws PcapNativeException, NotOpenException {
        NativeLong nposition;
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                throw new NotOpenException();
            }
            nposition = NativeMappings.pcap_dump_ftell(this.dumper);
        }
        long position = nposition.longValue();
        if (position < 0L) {
            throw new PcapNativeException("Failed to get the file position.");
        }
        return position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.thisLock;
        synchronized (object) {
            if (!this.open) {
                logger.warn("Already closed.");
                return;
            }
            NativeMappings.pcap_dump_close(this.dumper);
            this.open = false;
        }
        logger.info("Closed.");
    }
}

