/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import java.net.InetAddress;
import org.pcap4j.core.NativeMappings;
import org.pcap4j.core.PcapAddress;

abstract class AbstractPcapAddress
implements PcapAddress {
    private final InetAddress address;
    private final InetAddress netmask;
    private final InetAddress broadcastAddr;
    private final InetAddress dstAddr;

    protected AbstractPcapAddress(NativeMappings.pcap_addr pcapAddr) {
        if (pcapAddr == null) {
            throw new NullPointerException();
        }
        this.address = this.ntoInetAddress(pcapAddr.addr);
        if (pcapAddr.netmask != null && pcapAddr.netmask.sa_family != 0) {
            if (pcapAddr.addr.sa_family != pcapAddr.netmask.sa_family) {
                throw new AssertionError();
            }
            this.netmask = this.ntoInetAddress(pcapAddr.netmask);
        } else {
            this.netmask = null;
        }
        if (pcapAddr.broadaddr != null && pcapAddr.broadaddr.sa_family != 0) {
            if (pcapAddr.addr.sa_family != pcapAddr.broadaddr.sa_family) {
                throw new AssertionError();
            }
            this.broadcastAddr = this.ntoInetAddress(pcapAddr.broadaddr);
        } else {
            this.broadcastAddr = null;
        }
        if (pcapAddr.dstaddr != null && pcapAddr.dstaddr.sa_family != 0) {
            if (pcapAddr.addr.sa_family != pcapAddr.dstaddr.sa_family) {
                throw new AssertionError();
            }
            this.dstAddr = this.ntoInetAddress(pcapAddr.dstaddr);
        } else {
            this.dstAddr = null;
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public InetAddress getNetmask() {
        return this.netmask;
    }

    public InetAddress getBroadcastAddress() {
        return this.broadcastAddr;
    }

    public InetAddress getDestinationAddress() {
        return this.dstAddr;
    }

    protected abstract InetAddress ntoInetAddress(NativeMappings.sockaddr var1);

    public String toString() {
        StringBuilder sb = new StringBuilder(190);
        sb.append("address: [").append(this.address).append("] netmask: [").append(this.netmask).append("] broadcastAddr: [").append(this.broadcastAddr).append("] dstAddr [").append(this.dstAddr).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        AbstractPcapAddress other = (AbstractPcapAddress)this.getClass().cast(obj);
        return this.address.equals(other.address) && this.netmask.equals(other.netmask) && this.broadcastAddr.equals(other.broadcastAddr) && this.dstAddr.equals(other.dstAddr);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

