/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin;

import com.sun.tools.xjc.ErrorReceiver;
import org.jvnet.basicjaxb.locator.util.LocatorBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public class LoggingErrorReceiver
extends ErrorReceiver {
    private Logger logger = LoggerFactory.getLogger(LoggingErrorReceiver.class);
    private boolean verbose = false;
    private String messagePrefix = "ERROR";

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public void setMessagePrefix(String messagePrefix) {
        this.messagePrefix = messagePrefix;
    }

    public LoggingErrorReceiver() {
    }

    public LoggingErrorReceiver(Logger logger) {
        this.setLogger(logger);
    }

    public LoggingErrorReceiver(String messagePrefix) {
        this.setMessagePrefix(messagePrefix);
    }

    public LoggingErrorReceiver(String messagePrefix, Logger logger) {
        this.setMessagePrefix(messagePrefix);
        this.setLogger(logger);
    }

    public LoggingErrorReceiver(String messagePrefix, Logger logger, boolean verbose) {
        this.setMessagePrefix(messagePrefix);
        this.setLogger(logger);
        this.setVerbose(verbose);
    }

    public void warning(SAXParseException saxex) {
        if (this.isVerbose()) {
            this.getLogger().warn(this.getMessage(saxex), (Throwable)saxex);
        } else if (saxex.getMessage().contains("experimental")) {
            this.getLogger().warn("Current configuration is experimental!");
        } else {
            this.getLogger().warn(saxex.getMessage());
            this.getLogger().warn(this.getMessage(saxex));
        }
    }

    public void error(SAXParseException saxex) {
        this.getLogger().error(this.getMessage(saxex), (Throwable)saxex);
    }

    public void fatalError(SAXParseException saxex) {
        this.getLogger().error(this.getMessage(saxex), (Throwable)saxex);
    }

    public void info(SAXParseException saxex) {
        if (this.isVerbose()) {
            this.getLogger().info(this.getMessage(saxex));
        }
    }

    private String getMessage(SAXParseException ex) {
        String pub = ex.getPublicId();
        String sys = ex.getSystemId();
        int row = ex.getLineNumber();
        int col = ex.getColumnNumber();
        LocatorBean locatorBean = new LocatorBean(pub, sys, row, col);
        return this.getMessagePrefix() + " Location " + String.valueOf(locatorBean) + ".";
    }
}

