/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ListBackedMap<T, K, V>
extends AbstractMap<K, V> {
    private final List<T> list;
    private final BiFunction<K, V, T> keyValueToElement;
    private final Function<T, K> elementToKey;
    private final Function<T, V> elementToValue;

    public ListBackedMap(List<T> list, BiFunction<K, V, T> keyValueToElement, Function<T, K> elementToKey, Function<T, V> elementToValue) {
        this.list = list;
        this.keyValueToElement = keyValueToElement;
        this.elementToKey = elementToKey;
        this.elementToValue = elementToValue;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.list.stream().collect(Collectors.toMap(this.elementToKey, this.elementToValue)).entrySet();
    }

    @Override
    public V put(K key, V value) {
        Object previousValue = this.remove(key);
        this.list.add(this.keyValueToElement.apply(key, value));
        return previousValue;
    }

    public List<T> getList() {
        return this.list;
    }
}

