/*
 * Decompiled with CFR 0.152.
 */
package org.patrodyne.jvnet.basicjaxb.explore;

import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class ConsoleOutputStream
extends OutputStream {
    private JTextArea textArea = new JTextArea();

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public ConsoleOutputStream(int points) {
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("monospaced", 0, points));
    }

    @Override
    public void write(int b) throws IOException {
        this.getTextArea().append(String.valueOf((char)b));
        this.getTextArea().setCaretPosition(this.getTextArea().getDocument().getLength());
    }

    public void clear() {
        try {
            this.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("cannot clear", ex);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            int length = this.getTextArea().getDocument().getLength();
            this.getTextArea().getDocument().remove(0, length);
        }
        catch (BadLocationException ex) {
            throw new IOException("cannot close", ex);
        }
    }
}

