/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.valueconstructor;

import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.outline.FieldOutline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConstructorArgs {
    protected JDefinedClass definedClass;
    protected List<FieldOutline> superFieldList;
    protected List<FieldOutline> localFieldList;
    protected String javaDoc;

    public ConstructorArgs() {
    }

    public ConstructorArgs(JDefinedClass definedClass, FieldOutline[] superFields, FieldOutline[] localFields, String javaDoc) {
        this.definedClass = definedClass;
        this.superFieldList = Arrays.asList(superFields);
        this.localFieldList = Arrays.asList(localFields);
        this.javaDoc = javaDoc;
    }

    public ConstructorArgs(JDefinedClass definedClass, List<FieldOutline> superFieldList, List<FieldOutline> localFieldList, String javaDoc) {
        this.definedClass = definedClass;
        this.superFieldList = superFieldList;
        this.localFieldList = localFieldList;
        this.javaDoc = javaDoc;
    }

    public JDefinedClass getDefinedClass() {
        return this.definedClass;
    }

    public void setDefinedClass(JDefinedClass value) {
        this.definedClass = value;
    }

    public List<FieldOutline> getSuperFieldList() {
        if (this.superFieldList == null) {
            this.superFieldList = new ArrayList<FieldOutline>();
        }
        return this.superFieldList;
    }

    public List<FieldOutline> getLocalFieldList() {
        if (this.localFieldList == null) {
            this.localFieldList = new ArrayList<FieldOutline>();
        }
        return this.localFieldList;
    }

    public String getJavaDoc() {
        return this.javaDoc;
    }

    public void setJavaDoc(String value) {
        this.javaDoc = value;
    }

    public int hashCode() {
        List<FieldOutline> theLocalFieldList;
        List<FieldOutline> theSuperFieldList;
        int currentHashCode = 1;
        currentHashCode *= 31;
        JDefinedClass theDefinedClass = this.getDefinedClass();
        if (this.definedClass != null) {
            currentHashCode += theDefinedClass.hashCode();
        }
        currentHashCode *= 31;
        List<FieldOutline> list = theSuperFieldList = this.superFieldList != null && !this.superFieldList.isEmpty() ? this.getSuperFieldList() : null;
        if (this.superFieldList != null && !this.superFieldList.isEmpty()) {
            currentHashCode += theSuperFieldList.hashCode();
        }
        currentHashCode *= 31;
        List<FieldOutline> list2 = theLocalFieldList = this.localFieldList != null && !this.localFieldList.isEmpty() ? this.getLocalFieldList() : null;
        if (this.localFieldList != null && !this.localFieldList.isEmpty()) {
            currentHashCode += theLocalFieldList.hashCode();
        }
        return currentHashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        List<FieldOutline> rhsLocalFieldList;
        List<FieldOutline> rhsSuperFieldList;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ConstructorArgs that = (ConstructorArgs)object;
        JDefinedClass lhsDefinedClass = this.getDefinedClass();
        JDefinedClass rhsDefinedClass = that.getDefinedClass();
        if (this.definedClass != null) {
            if (that.definedClass == null) return false;
            if (!lhsDefinedClass.equals(rhsDefinedClass)) {
                return false;
            }
        } else if (that.definedClass != null) {
            return false;
        }
        List<FieldOutline> lhsSuperFieldList = this.superFieldList != null && !this.superFieldList.isEmpty() ? this.getSuperFieldList() : null;
        List<FieldOutline> list = rhsSuperFieldList = that.superFieldList != null && !that.superFieldList.isEmpty() ? that.getSuperFieldList() : null;
        if (this.superFieldList != null && !this.superFieldList.isEmpty()) {
            if (that.superFieldList == null || that.superFieldList.isEmpty()) return false;
            if (!lhsSuperFieldList.equals(rhsSuperFieldList)) {
                return false;
            }
        } else if (that.superFieldList != null && !that.superFieldList.isEmpty()) {
            return false;
        }
        List<FieldOutline> lhsLocalFieldList = this.localFieldList != null && !this.localFieldList.isEmpty() ? this.getLocalFieldList() : null;
        List<FieldOutline> list2 = rhsLocalFieldList = that.localFieldList != null && !that.localFieldList.isEmpty() ? that.getLocalFieldList() : null;
        if (this.localFieldList != null && !this.localFieldList.isEmpty()) {
            if (that.localFieldList == null || that.localFieldList.isEmpty()) return false;
            if (lhsLocalFieldList.equals(rhsLocalFieldList)) return true;
            return false;
        }
        if (that.localFieldList == null || that.localFieldList.isEmpty()) return true;
        return false;
    }
}

