/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.util;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassRef;
import com.sun.tools.xjc.outline.ClassOutline;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.util.JClassUtils;

public class StrategyClassUtils {
    public static <T> JExpression createStrategyInstanceExpression(JCodeModel codeModel, Class<? extends T> strategyInterface, String strategyClassName) {
        try {
            Class<?> strategyClass = Class.forName(strategyClassName);
            JClass strategyJClass = codeModel.ref(strategyClass);
            try {
                Method getInstanceMethod = strategyClass.getMethod("getInstance", new Class[0]);
                if (getInstanceMethod != null && strategyInterface.isAssignableFrom(getInstanceMethod.getReturnType()) && Modifier.isStatic(getInstanceMethod.getModifiers()) && Modifier.isPublic(getInstanceMethod.getModifiers())) {
                    return strategyJClass.staticInvoke("getInstance");
                }
            }
            catch (Exception getInstanceMethod) {
                // empty catch block
            }
            try {
                Field instance2Field = strategyClass.getField("INSTANCE");
                if (instance2Field != null && strategyInterface.isAssignableFrom(instance2Field.getType()) && Modifier.isStatic(instance2Field.getModifiers()) && Modifier.isPublic(instance2Field.getModifiers())) {
                    return strategyJClass.staticRef("INSTANCE");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return JExpr._new((JClass)strategyJClass);
        }
        catch (ClassNotFoundException cnfex) {
            JClass strategyJClass = codeModel.ref(strategyClassName);
            return JExpr._new((JClass)strategyJClass);
        }
    }

    public static <T> Boolean superClassImplements(ClassOutline classOutline, Ignoring ignoring, Class<? extends T> theInterface, Boolean unknown) {
        Boolean sci = StrategyClassUtils.superClassImplements(classOutline, ignoring, theInterface);
        return sci != null ? sci : unknown;
    }

    public static <T> Boolean superClassImplements(ClassOutline classOutline, Ignoring ignoring, Class<? extends T> theInterface) {
        ClassOutline baseClassOutline;
        JClass implSuperclass;
        if (classOutline.implClass != null && classOutline.implClass._extends() != null && JClassUtils.isInstanceOf((JClass)(implSuperclass = classOutline.implClass._extends()), theInterface)) {
            return Boolean.TRUE;
        }
        CClassInfo baseClassInfo = classOutline.target.getBaseClass();
        if (baseClassInfo != null && ignoring.isIgnored(baseClassOutline = classOutline.parent().getClazz(baseClassInfo))) {
            return Boolean.FALSE;
        }
        CClassRef refBaseClassInfo = classOutline.target.getRefBaseClass();
        if (refBaseClassInfo != null) {
            try {
                if (theInterface.isAssignableFrom(Class.forName(refBaseClassInfo.fullName()))) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            catch (ClassNotFoundException ignored) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static <T> Boolean superClassNotIgnored(ClassOutline classOutline, Ignoring ignoring) {
        CClassInfo baseClassInfo = classOutline.target.getBaseClass();
        CClassRef refBaseClassInfo = classOutline.target.getRefBaseClass();
        if (baseClassInfo != null) {
            if (ignoring.isIgnored(classOutline.parent().getClazz(baseClassInfo))) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (refBaseClassInfo != null) {
            return Boolean.TRUE;
        }
        return null;
    }

    public static <T> Boolean superClassImplements(ClassOutline classOutline, Ignoring ignoring, String methodName, String[] parmTypeNames, Boolean unknown) {
        Boolean sci = StrategyClassUtils.superClassImplements(classOutline, ignoring, methodName, parmTypeNames);
        return sci != null ? sci : unknown;
    }

    public static <T> Boolean superClassImplements(ClassOutline classOutline, Ignoring ignoring, String methodName, String[] parmTypeNames) {
        ClassOutline baseClassOutline;
        JClass implClassExtends;
        if (classOutline.implClass != null && classOutline.implClass._extends() != null && (implClassExtends = classOutline.implClass._extends()) instanceof JDefinedClass) {
            JDefinedClass implSuperClass = (JDefinedClass)implClassExtends;
            if (JClassUtils.classHasMethod((JDefinedClass)implSuperClass, (String)methodName, (String[])parmTypeNames)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        CClassInfo baseClassInfo = classOutline.target.getBaseClass();
        if (baseClassInfo != null && ignoring.isIgnored(baseClassOutline = classOutline.parent().getClazz(baseClassInfo))) {
            return Boolean.FALSE;
        }
        CClassRef refBaseClassInfo = classOutline.target.getRefBaseClass();
        if (refBaseClassInfo != null) {
            try {
                Class<?> baseClass = Class.forName(refBaseClassInfo.fullName());
                if (JClassUtils.classHasMethod(baseClass, (String)methodName, (String[])parmTypeNames)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            catch (ClassNotFoundException ignored) {
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

