/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.util;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationClassValue;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSXPath;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlElements;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Selector {
    public static final String XML_ATTRIBUTE_NAME = XmlAttribute.class.getName();
    public static final String XML_ELEMENT_NAME = XmlElement.class.getName();
    public static final String XML_ELEMENTS_NAME = XmlElements.class.getName();
    public static final String XML_ELEMENT_REF_NAME = XmlElementRef.class.getName();
    public static final String XML_ELEMENT_REFS_NAME = XmlElementRefs.class.getName();
    private ClassOutline classOutline;
    private XSIdentityConstraint identityConstraint;
    private Map<JDefinedClass, List<JFieldVar>> selectedFieldMap;
    private List<List<String>> selectedPaths;
    private List<List<String>> selectedFieldPaths;

    public ClassOutline getClassOutline() {
        return this.classOutline;
    }

    protected void setClassOutline(ClassOutline classOutline) {
        this.classOutline = classOutline;
    }

    public XSIdentityConstraint getIdentityConstraint() {
        return this.identityConstraint;
    }

    protected void setIdentityConstraint(XSIdentityConstraint identityConstraint) {
        this.identityConstraint = identityConstraint;
    }

    public Map<JDefinedClass, List<JFieldVar>> getSelectedFieldMap() {
        if (this.selectedFieldMap == null) {
            this.setSelectedFieldMap(new HashMap<JDefinedClass, List<JFieldVar>>());
        }
        return this.selectedFieldMap;
    }

    protected void setSelectedFieldMap(Map<JDefinedClass, List<JFieldVar>> selectedFieldMap) {
        this.selectedFieldMap = selectedFieldMap;
    }

    public List<List<String>> getSelectedPaths() {
        if (this.selectedPaths == null) {
            this.setSelectedPaths(new ArrayList<List<String>>());
        }
        return this.selectedPaths;
    }

    protected void setSelectedPaths(List<List<String>> selectedPaths) {
        this.selectedPaths = selectedPaths;
    }

    public List<List<String>> getSelectedFieldPaths() {
        if (this.selectedFieldPaths == null) {
            this.setSelectedFieldPaths(new ArrayList<List<String>>());
        }
        return this.selectedFieldPaths;
    }

    protected void setSelectedFieldPaths(List<List<String>> selectedFieldPaths) {
        this.selectedFieldPaths = selectedFieldPaths;
    }

    public Selector(ClassOutline classOutline, XSIdentityConstraint identityConstraint) {
        this.setClassOutline(classOutline);
        this.setIdentityConstraint(identityConstraint);
        this.initialize();
    }

    private void initialize() {
        if (this.getSelectedFieldMap().isEmpty()) {
            this.parseSelector(this.getIdentityConstraint().getSelector());
            for (XSXPath field : this.getIdentityConstraint().getFields()) {
                List<String> selectedFieldPath = this.parseField(field);
                if (selectedFieldPath.isEmpty()) continue;
                this.getSelectedFieldPaths().add(selectedFieldPath);
            }
            JDefinedClass rootClass = this.getClassOutline().getImplClass();
            HashSet<JDefinedClass> selectedClassSet = new HashSet<JDefinedClass>();
            for (List<String> selectedPath : this.getSelectedPaths()) {
                HashSet<JDefinedClass> selectClassSet = new HashSet<JDefinedClass>();
                selectClassSet.add(rootClass);
                Iterator<String> iterator = selectedPath.iterator();
                while (iterator.hasNext()) {
                    String selectedPathPart = iterator.next();
                    if (selectedPathPart.startsWith(".")) {
                        if (selectedPath.size() != 1) continue;
                        selectedClassSet.add(rootClass);
                        continue;
                    }
                    HashSet<JDefinedClass> nextSelectClassSet = new HashSet<JDefinedClass>();
                    for (JDefinedClass selectClass : selectClassSet) {
                        Set<JDefinedClass> walkSelectedPath = this.walkSelectedPath(selectedPathPart, selectClass);
                        if (iterator.hasNext()) {
                            nextSelectClassSet.addAll(walkSelectedPath);
                            continue;
                        }
                        selectedClassSet.addAll(walkSelectedPath);
                    }
                    selectClassSet = nextSelectClassSet;
                }
            }
            for (JDefinedClass selectedClass : selectedClassSet) {
                for (Map.Entry<String, JFieldVar> entry : selectedClass.fields().entrySet()) {
                    boolean addedField = false;
                    for (JAnnotationUse selectedClassFieldAnno : ((JFieldVar)entry.getValue()).annotations()) {
                        JClass selectedClassFieldAnnoClass = selectedClassFieldAnno.getAnnotationClass();
                        if (XML_ELEMENTS_NAME.equals(selectedClassFieldAnnoClass.fullName())) {
                            JAnnotationValue scFieldAnnoMbrValue = (JAnnotationValue)selectedClassFieldAnno.getAnnotationMembers().get("value");
                            if (!(scFieldAnnoMbrValue instanceof JAnnotationArrayMember)) continue;
                            JAnnotationArrayMember scFieldAnnoMbrValues = (JAnnotationArrayMember)scFieldAnnoMbrValue;
                            for (JAnnotationUse scFieldAnnoMbr : scFieldAnnoMbrValues.annotations()) {
                                JClass scFieldAnnoMbrClass = scFieldAnnoMbr.getAnnotationClass();
                                addedField = this.walkSelectedField(selectedClass, entry, scFieldAnnoMbr, scFieldAnnoMbrClass);
                            }
                            continue;
                        }
                        addedField = this.walkSelectedField(selectedClass, entry, selectedClassFieldAnno, selectedClassFieldAnnoClass);
                    }
                    if (addedField) continue;
                    this.walkSelectedField(selectedClass, entry);
                }
            }
        }
    }

    private void walkSelectedField(JDefinedClass selectedClass, Map.Entry<String, JFieldVar> selectedClassField) {
        JFieldVar selectedClassFieldValue = selectedClassField.getValue();
        for (List<String> selectedFieldPath : this.getSelectedFieldPaths()) {
            String fieldElementName;
            String selectedFieldPathPart = selectedFieldPath.get(0);
            if (selectedFieldPathPart.startsWith("@")) {
                selectedFieldPathPart = selectedFieldPathPart.substring(1);
            }
            if (!selectedFieldPathPart.equals(fieldElementName = selectedClassFieldValue.name())) continue;
            if (!this.getSelectedFieldMap().containsKey(selectedClass)) {
                this.getSelectedFieldMap().put(selectedClass, new ArrayList());
            }
            this.getSelectedFieldMap().get(selectedClass).add(selectedClassFieldValue);
        }
    }

    private boolean walkSelectedField(JDefinedClass selectedClass, Map.Entry<String, JFieldVar> selectedClassField, JAnnotationUse selectedClassFieldAnno, JClass selectedClassFieldAnnoClass) {
        boolean addedField = false;
        JFieldVar selectedClassFieldValue = selectedClassField.getValue();
        for (List<String> selectedFieldPath : this.getSelectedFieldPaths()) {
            String targetAnnotationName = XML_ELEMENT_NAME;
            String selectedFieldPathPart = selectedFieldPath.get(0);
            if (selectedFieldPathPart.startsWith("@")) {
                targetAnnotationName = XML_ATTRIBUTE_NAME;
                selectedFieldPathPart = selectedFieldPathPart.substring(1);
            }
            if (!targetAnnotationName.equals(selectedClassFieldAnnoClass.fullName())) continue;
            String fieldElementName = null;
            JAnnotationValue selectedClassFieldAnnoMbrName = (JAnnotationValue)selectedClassFieldAnno.getAnnotationMembers().get("name");
            fieldElementName = selectedClassFieldAnnoMbrName != null ? selectedClassFieldAnnoMbrName.toString() : selectedClassFieldValue.name();
            if (!selectedFieldPathPart.equals(fieldElementName)) continue;
            if (!this.getSelectedFieldMap().containsKey(selectedClass)) {
                this.getSelectedFieldMap().put(selectedClass, new ArrayList());
            }
            this.getSelectedFieldMap().get(selectedClass).add(selectedClassFieldValue);
            addedField = true;
        }
        return addedField;
    }

    private Set<JDefinedClass> walkSelectedPath(String selectedPathPart, JDefinedClass selectClass) {
        HashSet<JDefinedClass> walkSelectedPath = new HashSet<JDefinedClass>();
        for (Map.Entry<String, JFieldVar> entry : selectClass.fields().entrySet()) {
            boolean addedPath = false;
            for (JAnnotationUse scFieldAnno : ((JFieldVar)entry.getValue()).annotations()) {
                JAnnotationValue scFieldAnnoMbrValue;
                JClass scFieldAnnoClass = scFieldAnno.getAnnotationClass();
                String scFACName = scFieldAnnoClass.fullName();
                if (XML_ELEMENT_NAME.equals(scFACName) || XML_ELEMENT_REF_NAME.equals(scFACName)) {
                    addedPath = this.walkSelectedPath(walkSelectedPath, selectedPathPart, entry, scFieldAnno);
                    continue;
                }
                if (!XML_ELEMENTS_NAME.equals(scFACName) && !XML_ELEMENT_REFS_NAME.equals(scFACName) || !((scFieldAnnoMbrValue = (JAnnotationValue)scFieldAnno.getAnnotationMembers().get("value")) instanceof JAnnotationArrayMember)) continue;
                JAnnotationArrayMember scFieldAnnoMbrValues = (JAnnotationArrayMember)scFieldAnnoMbrValue;
                for (JAnnotationUse scFieldAnnoMbr : scFieldAnnoMbrValues.annotations()) {
                    addedPath = this.walkSelectedPath(walkSelectedPath, selectedPathPart, entry, scFieldAnnoMbr);
                }
            }
            if (addedPath) continue;
            this.walkSelectedPath(walkSelectedPath, selectedPathPart, entry);
        }
        return walkSelectedPath;
    }

    private void walkSelectedPath(Set<JDefinedClass> walkSelectedPath, String selectedPathPart, Map.Entry<String, JFieldVar> scField) {
        JFieldVar scFieldValue = scField.getValue();
        String fieldElementName = scFieldValue.name();
        if (selectedPathPart.equals(fieldElementName) || selectedPathPart.equals("*")) {
            JDefinedClass nextSelectClass = null;
            if (scFieldValue.type() instanceof JClass) {
                JClass scFieldValueType = (JClass)scFieldValue.type();
                if (scFieldValueType.isParameterized()) {
                    for (JClass scFieldValueTypeParam : scFieldValueType.getTypeParameters()) {
                        if (!(scFieldValueTypeParam instanceof JDefinedClass)) continue;
                        nextSelectClass = (JDefinedClass)scFieldValueTypeParam;
                        this.addExtendedSelectClass(walkSelectedPath, nextSelectClass);
                    }
                } else if (scFieldValueType instanceof JDefinedClass) {
                    nextSelectClass = (JDefinedClass)scFieldValueType;
                    this.addExtendedSelectClass(walkSelectedPath, nextSelectClass);
                }
            }
        }
    }

    private boolean walkSelectedPath(Set<JDefinedClass> walkSelectedPath, String selectedPathPart, Map.Entry<String, JFieldVar> scField, JAnnotationUse scFieldAnno) {
        boolean addedPath = false;
        JFieldVar scFieldValue = scField.getValue();
        String fieldElementName = null;
        JAnnotationValue scFieldAnnoMbrName = (JAnnotationValue)scFieldAnno.getAnnotationMembers().get("name");
        fieldElementName = scFieldAnnoMbrName != null ? scFieldAnnoMbrName.toString() : scFieldValue.name();
        if (selectedPathPart.equals(fieldElementName) || selectedPathPart.equals("*")) {
            JAnnotationValue scFieldAnnoMbrType = (JAnnotationValue)scFieldAnno.getAnnotationMembers().get("type");
            if (scFieldAnnoMbrType instanceof JAnnotationClassValue) {
                JAnnotationClassValue scFieldAnnoMbrClass = (JAnnotationClassValue)scFieldAnnoMbrType;
                JClass scFieldAnnoMbrClassType = scFieldAnnoMbrClass.type();
                addedPath = this.nextSelectClass(walkSelectedPath, scFieldAnnoMbrClassType);
            }
            if (!addedPath && scFieldValue.type() instanceof JClass) {
                JClass scFieldValueType = (JClass)scFieldValue.type();
                addedPath = this.nextSelectClass(walkSelectedPath, scFieldValueType);
            }
        }
        return addedPath;
    }

    private boolean nextSelectClass(Set<JDefinedClass> walkSelectedPath, JClass valueType) {
        boolean addedPath = false;
        if (valueType.isParameterized()) {
            for (JClass scFieldAnnoMbrClassTypeParam : valueType.getTypeParameters()) {
                if (!(scFieldAnnoMbrClassTypeParam instanceof JDefinedClass)) continue;
                JDefinedClass nextSelectClass = (JDefinedClass)scFieldAnnoMbrClassTypeParam;
                this.addExtendedSelectClass(walkSelectedPath, nextSelectClass);
                addedPath = true;
            }
        } else if (valueType instanceof JDefinedClass) {
            JDefinedClass nextSelectClass = (JDefinedClass)valueType;
            this.addExtendedSelectClass(walkSelectedPath, nextSelectClass);
            addedPath = true;
        }
        return addedPath;
    }

    private void addExtendedSelectClass(Set<JDefinedClass> selectedSet, JDefinedClass selectClass) {
        selectedSet.add(selectClass);
        if (selectClass._extends() instanceof JDefinedClass) {
            JDefinedClass extendsSelectClass = (JDefinedClass)selectClass._extends();
            this.addExtendedSelectClass(selectedSet, extendsSelectClass);
        }
    }

    private void parseSelector(XSXPath selector) {
        String xpathValue = selector.getXPath().value;
        for (String xpath : xpathValue.split("\\|")) {
            ArrayList<String> selectedPath = new ArrayList<String>();
            for (String xpathPart : xpath.trim().split("/+")) {
                int prefixIndex = xpathPart.indexOf(58);
                if (prefixIndex >= 0) {
                    xpathPart = xpathPart.substring(prefixIndex + 1);
                }
                if (selectedPath.isEmpty()) {
                    selectedPath.add(xpathPart.trim());
                    continue;
                }
                if (".".equals(xpathPart)) continue;
                selectedPath.add(xpathPart.trim());
            }
            if (selectedPath.isEmpty()) continue;
            this.getSelectedPaths().add(selectedPath);
        }
    }

    private List<String> parseField(XSXPath field) {
        String xpathValue = field.getXPath().value;
        ArrayList<String> fieldPath = new ArrayList<String>();
        for (String xpathPart : xpathValue.trim().split("/+")) {
            int prefixIndex = xpathPart.indexOf(58);
            if (prefixIndex >= 0) {
                xpathPart = xpathPart.substring(prefixIndex + 1);
            }
            if (".".equals(xpathPart) || "*".equals(xpathPart)) continue;
            fieldPath.add(xpathPart.trim());
        }
        return fieldPath;
    }
}

