/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.simpletostring;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.jvnet.basicjaxb.plugin.codegenerator.Arguments;

public class ToStringArguments
implements Arguments<ToStringArguments> {
    private final JCodeModel codeModel;
    private final JVar stringBuilder;
    private final JVar value;
    private final JExpression hasSetValue;
    private String fieldSeparator;
    private String fieldName;
    private boolean showChildItems;
    private boolean hasDefaultValue;

    public ToStringArguments(JCodeModel codeModel, JVar stringBuilder, JVar value, JExpression hasSetValue, String fieldSeparator, String fieldName, boolean showChildItems, boolean hasDefaultValue) {
        this.codeModel = Objects.requireNonNull(codeModel);
        this.stringBuilder = Objects.requireNonNull(stringBuilder);
        this.value = Objects.requireNonNull(value);
        this.hasSetValue = Objects.requireNonNull(hasSetValue);
        this.fieldSeparator = fieldSeparator;
        this.fieldName = fieldName;
        this.showChildItems = showChildItems;
        this.hasDefaultValue = hasDefaultValue;
    }

    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    public JVar stringBuilder() {
        return this.stringBuilder;
    }

    public JVar value() {
        return this.value;
    }

    public JExpression hasSetValue() {
        return this.hasSetValue;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isShowChildItems() {
        return this.showChildItems;
    }

    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }

    private ToStringArguments spawn(JVar value, JExpression hasSetValue) {
        return new ToStringArguments(this.getCodeModel(), this.stringBuilder(), value, hasSetValue, this.getFieldSeparator(), this.getFieldName(), this.isShowChildItems(), this.hasDefaultValue());
    }

    @Override
    public ToStringArguments property(JBlock block, String propertyName, String propertyMethod, JType declarablePropertyType, JType propertyType, Collection<JType> possiblePropertyTypes) {
        JVar propertyValue = block.decl(8, declarablePropertyType, this.value().name() + propertyName, (JExpression)this.value().invoke(propertyMethod));
        boolean isAlwaysSet = propertyType.isPrimitive();
        JExpression propertyHasSetValue = isAlwaysSet ? JExpr.TRUE : propertyValue.ne(JExpr._null());
        return this.spawn(propertyValue, propertyHasSetValue);
    }

    @Override
    public ToStringArguments iterator(JBlock block, JType elementType) {
        JVar listIterator = block.decl(8, (JType)this.getCodeModel().ref(ListIterator.class).narrow(elementType), this.value().name() + "ListIterator", (JExpression)this.value().invoke("listIterator"));
        return this.spawn(listIterator, JExpr.TRUE);
    }

    @Override
    public ToStringArguments element(JBlock subBlock, JType elementType) {
        JVar elementValue = subBlock.decl(8, elementType, this.value().name() + "Element", (JExpression)this.value().invoke("next"));
        boolean isElementAlwaysSet = elementType.isPrimitive();
        JExpression elementHasSetValue = isElementAlwaysSet ? JExpr.TRUE : elementValue.ne(JExpr._null());
        return this.spawn(elementValue, elementHasSetValue);
    }

    @Override
    public JExpression _instanceof(JType type) {
        return this.value()._instanceof(type);
    }

    @Override
    public ToStringArguments cast(String suffix, JBlock block, JType jaxbElementType, boolean suppressWarnings) {
        JVar castedValue = block.decl(8, jaxbElementType, this.value().name() + suffix, (JExpression)JExpr.cast((JType)jaxbElementType, (JExpression)this.value()));
        if (suppressWarnings) {
            castedValue.annotate(SuppressWarnings.class).param("value", "unchecked");
        }
        return this.spawn(castedValue, JExpr.TRUE);
    }

    @Override
    public JBlock ifHasSetValue(JBlock block, boolean isAlwaysSet, boolean checkForNullRequired) {
        if (isAlwaysSet || !checkForNullRequired) {
            return block;
        }
        return block._if(this.hasSetValue())._then();
    }

    @Override
    public JBlock _while(JBlock block) {
        JBlock subBlock = block._while((JExpression)this.value().invoke("hasNext")).body();
        return subBlock;
    }

    public boolean valueIsCollection() {
        boolean isCollection = false;
        if (this.value() != null && this.value().type() instanceof JClass) {
            JClass jclass = (JClass)this.value().type().erasure();
            isCollection = this.getCodeModel().ref(Collection.class).isAssignableFrom(jclass) || this.getCodeModel().ref(Map.class).isAssignableFrom(jclass);
        }
        return isCollection;
    }
}

