/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.jaxbindex;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.fmt.JTextFile;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.outline.PackageOutline;
import org.jvnet.basicjaxb.plugin.AbstractPlugin;
import org.jvnet.basicjaxb.util.CodeModelUtils;
import org.xml.sax.ErrorHandler;

public class JaxbIndexPlugin
extends AbstractPlugin {
    private static final String OPTION_NAME = "Xjaxbindex";
    private static final String OPTION_DESC = "generate per-package 'jaxb.index' file";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Verbose.: " + this.isVerbose());
            sb.append("\n  Debug...: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (PackageOutline packageOutline : outline.getAllPackageContexts()) {
            JPackage _package = packageOutline._package();
            JTextFile indexFile = new JTextFile("jaxb.index");
            StringBuilder sb = new StringBuilder();
            for (ClassOutline classOutline : packageOutline.getClasses()) {
                String simpleType = CodeModelUtils.getLocalClassName((JClass)classOutline.ref);
                sb.append(simpleType);
                sb.append("\n");
                this.trace("run; Package={}, File={}, Type={}", new Object[]{_package.name(), indexFile.name(), simpleType});
            }
            indexFile.setContents(sb.toString());
            _package.addResourceFile((JResourceFile)indexFile);
            this.debug("run; Package={}, File={}", new Object[]{_package.name(), indexFile.name()});
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }
}

