/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.util;

import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.plugin.util.ArrayUtils;
import org.jvnet.basicjaxb.plugin.util.Predicate;

public class OutlineUtils {
    private OutlineUtils() {
    }

    public static FieldOutline[] filter(ClassOutline classOutline, Ignoring ignoring) {
        return OutlineUtils.filter(classOutline.getDeclaredFields(), ignoring);
    }

    public static FieldOutline[] filter(FieldOutline[] fieldOutlines, final Ignoring ignoring) {
        return ArrayUtils.filter(fieldOutlines, new Predicate<FieldOutline>(){

            @Override
            public boolean evaluate(FieldOutline fieldOutline) {
                return !ignoring.isIgnored(fieldOutline);
            }
        }, FieldOutline.class);
    }

    public static ClassOutline[] filter(Outline outline, Ignoring ignoring) {
        Collection classes = outline.getClasses();
        ClassOutline[] classOutlines = classes.toArray(new ClassOutline[classes.size()]);
        return OutlineUtils.filter(classOutlines, ignoring);
    }

    public static ClassOutline[] filter(ClassOutline[] classOutlines, final Ignoring ignoring) {
        ClassOutline[] orderedOutlines = OutlineUtils.orderBySuper(classOutlines);
        return ArrayUtils.filter(orderedOutlines, new Predicate<ClassOutline>(){

            @Override
            public boolean evaluate(ClassOutline classOutline) {
                return !ignoring.isIgnored(classOutline);
            }
        }, ClassOutline.class);
    }

    public static ClassOutline[] orderBySuper(ClassOutline[] toSort) {
        ArrayList<ClassOutline> toSortList = new ArrayList<ClassOutline>(Arrays.asList(toSort));
        OutlineUtils.orderBySuper(toSortList);
        return toSortList.toArray(new ClassOutline[toSortList.size()]);
    }

    public static void orderBySuper(List<ClassOutline> toSort) {
        ArrayList<ClassOutline> ordered = new ArrayList<ClassOutline>();
        boolean more = true;
        while (more && !toSort.isEmpty()) {
            more = false;
            for (ClassOutline co : toSort) {
                ClassOutline sc = co.getSuperClass();
                if (sc != null && !ordered.contains(sc)) continue;
                ordered.add(co);
                more = true;
            }
            toSort.removeAll(ordered);
        }
        if (toSort.isEmpty()) {
            toSort.addAll(ordered);
        } else {
            toSort.addAll(0, ordered);
        }
    }

    public static EnumOutline[] filter(Collection<EnumOutline> enumOutlines, final Ignoring ignoring) {
        EnumOutline[] enumOutlineArray = enumOutlines.toArray(new EnumOutline[enumOutlines.size()]);
        return ArrayUtils.filter(enumOutlineArray, new Predicate<EnumOutline>(){

            @Override
            public boolean evaluate(EnumOutline classOutline) {
                return !ignoring.isIgnored(classOutline);
            }
        }, EnumOutline.class);
    }
}

