/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.copyable;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.lang.CopyStrategy;
import org.jvnet.basicjaxb.lang.CopyTo;
import org.jvnet.basicjaxb.lang.JAXBCopyStrategy;
import org.jvnet.basicjaxb.locator.DefaultRootObjectLocator;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.CustomizedIgnoring;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.plugin.copyable.Customizations;
import org.jvnet.basicjaxb.plugin.util.OutlineUtils;
import org.jvnet.basicjaxb.plugin.util.StrategyClassUtils;
import org.jvnet.basicjaxb.util.ClassUtils;
import org.jvnet.basicjaxb.util.FieldAccessorFactory;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.jvnet.basicjaxb.util.PropertyFieldAccessorFactory;
import org.jvnet.basicjaxb.xjc.outline.FieldAccessorEx;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;

public class CopyablePlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "Xcopyable";
    private static final String OPTION_DESC = "generate reflection-free deep copying";
    private FieldAccessorFactory fieldAccessorFactory = PropertyFieldAccessorFactory.INSTANCE;
    private String copyStrategyClass = JAXBCopyStrategy.class.getName();
    private Ignoring ignoring = new CustomizedIgnoring(Customizations.IGNORED_ELEMENT_NAME, org.jvnet.basicjaxb.plugin.Customizations.IGNORED_ELEMENT_NAME, org.jvnet.basicjaxb.plugin.Customizations.GENERATED_ELEMENT_NAME);

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public FieldAccessorFactory getFieldAccessorFactory() {
        return this.fieldAccessorFactory;
    }

    public void setFieldAccessorFactory(FieldAccessorFactory fieldAccessorFactory) {
        this.fieldAccessorFactory = fieldAccessorFactory;
    }

    public String getCopyStrategyClass() {
        return this.copyStrategyClass;
    }

    public void setCopyStrategyClass(String copyStrategy) {
        this.copyStrategyClass = copyStrategy;
    }

    public JExpression createCopyStrategy(JCodeModel codeModel) {
        return StrategyClassUtils.createStrategyInstanceExpression(codeModel, CopyStrategy.class, this.getCopyStrategyClass());
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.IGNORED_ELEMENT_NAME, org.jvnet.basicjaxb.plugin.Customizations.IGNORED_ELEMENT_NAME, org.jvnet.basicjaxb.plugin.Customizations.GENERATED_ELEMENT_NAME);
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  CopyStrategyClass.: " + this.getCopyStrategyClass());
            sb.append("\n  Verbose...........: " + this.isVerbose());
            sb.append("\n  Debug.............: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (ClassOutline classOutline : OutlineUtils.filter(outline, this.getIgnoring())) {
            this.processClassOutline(classOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    protected void processClassOutline(ClassOutline classOutline) {
        JDefinedClass theClass = classOutline.implClass;
        if (!classOutline.target.isAbstract()) {
            this.generateObject$createNewInstance(classOutline, theClass);
        }
        if (!StrategyClassUtils.superClassImplements(classOutline, this.getIgnoring(), CopyTo.class, false).booleanValue()) {
            ClassUtils._implements((JDefinedClass)theClass, (JClass)theClass.owner().ref(CopyTo.class));
            this.generateObject$copyTo(classOutline, theClass);
            if (!StrategyClassUtils.superClassImplements(classOutline, this.getIgnoring(), Cloneable.class, false).booleanValue()) {
                ClassUtils._implements((JDefinedClass)theClass, (JClass)theClass.owner().ref(Cloneable.class));
                this.generateObject$clone(classOutline, theClass);
            }
        }
        this.generateCopyTo$copyTo(classOutline, theClass);
    }

    protected JMethod generateObject$clone(ClassOutline classOutline, JDefinedClass theClass) {
        JMethod clone = theClass.method(1, (JType)theClass.owner().ref(Object.class), "clone");
        clone.annotate(Override.class);
        JBlock body = clone.body();
        body._return((JExpression)JExpr.invoke((String)"copyTo").arg((JExpression)JExpr.invoke((String)"createNewInstance")));
        this.trace("{}, generateObject$clone; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
        return clone;
    }

    protected JMethod generateObject$copyTo(ClassOutline classOutline, JDefinedClass theClass) {
        JCodeModel codeModel = theClass.owner();
        JMethod copyTo$copyTo = theClass.method(1, (JType)codeModel.ref(Object.class), "copyTo");
        copyTo$copyTo.annotate(Override.class);
        JVar target = copyTo$copyTo.param(Object.class, "target");
        JBlock body = copyTo$copyTo.body();
        JVar copyStrategy = body.decl(8, (JType)codeModel.ref(CopyStrategy.class), "strategy", this.createCopyStrategy(codeModel));
        JInvocation thisRootLocator = JExpr._new((JClass)codeModel.ref(DefaultRootObjectLocator.class)).arg(JExpr._this());
        JVar thisLocator = body.decl(0, (JType)codeModel.ref(ObjectLocator.class), "thisLocator", JExpr._null());
        JConditional ifDebugEnabled = body._if((JExpression)copyStrategy.invoke("isDebugEnabled"));
        ifDebugEnabled._then().assign((JAssignmentTarget)thisLocator, (JExpression)thisRootLocator);
        JInvocation invokeCopyTo = JExpr.invoke((String)"copyTo").arg((JExpression)thisLocator).arg((JExpression)target).arg((JExpression)copyStrategy);
        body._return((JExpression)invokeCopyTo);
        this.debug("{}, generateObject$copyTo; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
        return copyTo$copyTo;
    }

    protected JMethod generateCopyTo$copyTo(ClassOutline classOutline, JDefinedClass theClass) {
        FieldAccessorEx sourceFieldAccessor;
        JVar draftCopy;
        JCodeModel codeModel = theClass.owner();
        ClassUtils._implements((JDefinedClass)theClass, (JClass)codeModel.ref(CopyTo.class));
        JMethod copyTo = theClass.method(1, (JType)codeModel.ref(Object.class), "copyTo");
        copyTo.annotate(Override.class);
        JVar locator = copyTo.param(ObjectLocator.class, "locator");
        JVar target = copyTo.param(Object.class, "target");
        JVar copyStrategy = copyTo.param(CopyStrategy.class, "strategy");
        JBlock body = copyTo.body();
        if (!classOutline.target.isAbstract()) {
            JExpression express = JOp.cond((JExpression)JOp.eq((JExpression)target, (JExpression)JExpr._null()), (JExpression)JExpr.invoke((String)"createNewInstance"), (JExpression)target);
            draftCopy = body.decl(8, (JType)codeModel.ref(Object.class), "draftCopy", express);
        } else {
            body._if(JExpr._null().eq((JExpression)target))._then()._throw((JExpression)JExpr._new((JClass)codeModel.ref(IllegalArgumentException.class)).arg("Target argument must not be null for abstract copyable classes."));
            draftCopy = target;
        }
        Boolean superClassImplementsCopyTo = StrategyClassUtils.superClassImplements(classOutline, this.getIgnoring(), CopyTo.class);
        if (superClassImplementsCopyTo != null && superClassImplementsCopyTo.booleanValue()) {
            body.invoke(JExpr._super(), "copyTo").arg((JExpression)locator).arg((JExpression)draftCopy).arg((JExpression)copyStrategy);
        }
        FieldOutline[] declaredFields = OutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring());
        HashMap<FieldOutline, FieldAccessorEx> sourceFieldAccessorMap = new HashMap<FieldOutline, FieldAccessorEx>();
        for (FieldOutline fieldOutline : declaredFields) {
            sourceFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, JExpr._this());
            if (sourceFieldAccessor.isConstant()) continue;
            sourceFieldAccessorMap.put(fieldOutline, sourceFieldAccessor);
        }
        if (sourceFieldAccessorMap.size() > 0) {
            JBlock bl = body._if(draftCopy._instanceof((JType)theClass))._then();
            JVar copy = bl.decl(8, (JType)theClass, "copy", (JExpression)JExpr.cast((JType)theClass, (JExpression)draftCopy));
            for (FieldOutline fieldOutline : sourceFieldAccessorMap.keySet()) {
                sourceFieldAccessor = (FieldAccessorEx)sourceFieldAccessorMap.get(fieldOutline);
                FieldAccessorEx copyFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, (JExpression)copy);
                if (sourceFieldAccessor.isConstant()) continue;
                JBlock block = bl.block();
                JExpression sourceIsSetEx = sourceFieldAccessor.isAlwaysSet() || sourceFieldAccessor.hasSetValue() == null ? JExpr.TRUE : sourceFieldAccessor.hasSetValue();
                JVar sourceIsSet = block.decl(codeModel.ref(Boolean.class).unboxify(), "sourceFieldIsSet", sourceIsSetEx);
                JVar shouldBeCopied = block.decl((JType)codeModel.ref(Boolean.class), this.fieldName("source") + "ShouldBeCopiedAndSet", (JExpression)copyStrategy.invoke("shouldBeCopiedAndSet").arg((JExpression)locator).arg((JExpression)sourceIsSet));
                JConditional ifShouldBeSetConditional = block._if(JOp.eq((JExpression)shouldBeCopied, (JExpression)codeModel.ref(Boolean.class).staticRef("TRUE")));
                JBlock ifShouldBeSetBlock = ifShouldBeSetConditional._then();
                JConditional ifShouldNotBeSetConditional = ifShouldBeSetConditional._elseif(JOp.eq((JExpression)shouldBeCopied, (JExpression)codeModel.ref(Boolean.class).staticRef("FALSE")));
                JBlock ifShouldBeUnsetBlock = ifShouldNotBeSetConditional._then();
                JType copyFieldType = sourceFieldAccessor.getType();
                JVar sourceField = ifShouldBeSetBlock.decl(copyFieldType, this.fieldName("source"));
                sourceFieldAccessor.toRawValue(ifShouldBeSetBlock, sourceField);
                String fieldName = this.fieldName(fieldOutline);
                JInvocation sourceFieldLocatorEx = codeModel.ref(org.jvnet.basicjaxb.locator.util.LocatorUtils.class).staticInvoke("property").arg((JExpression)locator).arg(fieldName).arg((JExpression)sourceField);
                JVar sourceFieldLocator = ifShouldBeSetBlock.decl(locator.type(), "sourceFieldLocator", (JExpression)sourceFieldLocatorEx);
                JInvocation builtCopy = JExpr.invoke((JExpression)copyStrategy, (String)"copy").arg((JExpression)sourceFieldLocator).arg((JExpression)sourceField).arg((JExpression)sourceIsSet);
                JVar copyField = ifShouldBeSetBlock.decl(copyFieldType, this.fieldName("copy"), (JExpression)(copyFieldType.isPrimitive() ? builtCopy : JExpr.cast((JType)copyFieldType, (JExpression)builtCopy)));
                if (copyFieldType instanceof JClass && ((JClass)copyFieldType).isParameterized()) {
                    copyField.annotate(SuppressWarnings.class).param("value", "unchecked");
                }
                copyFieldAccessor.fromRawValue(ifShouldBeSetBlock, this.fieldName("unique"), (JExpression)copyField);
                copyFieldAccessor.unsetValues(ifShouldBeUnsetBlock);
                this.trace("{}, generateCopyTo$copyTo; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((Locator)fieldOutline.getPropertyInfo().getLocator()), theClass.name(), fieldName});
            }
        }
        body._return((JExpression)draftCopy);
        return copyTo;
    }

    protected JMethod generateObject$createNewInstance(ClassOutline classOutline, JDefinedClass theClass) {
        JMethod existingMethod = theClass.getMethod("createNewInstance", new JType[0]);
        if (existingMethod == null) {
            JMethod newMethod = theClass.method(1, (JType)theClass.owner().ref(Object.class), "createNewInstance");
            newMethod.annotate(Override.class);
            JBlock body = newMethod.body();
            body._return((JExpression)JExpr._new((JClass)theClass));
            this.trace("{}, generateObject$createNewInstance; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
            return newMethod;
        }
        return existingMethod;
    }

    private String fieldName(FieldOutline fieldOutline) {
        return fieldOutline.getPropertyInfo().getName(false);
    }

    private String fieldName(String prefix) {
        return prefix + "Field";
    }

    private String fieldName(String prefix, FieldOutline fieldOutline) {
        return prefix + "Field" + fieldOutline.getPropertyInfo().getName(true);
    }
}

