/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.autoinheritance;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.LinkedList;
import java.util.List;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.xml.sax.ErrorHandler;

public class AutoInheritancePlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "XautoInheritance";
    private static final String OPTION_DESC = "globally extend elements and/or types from a class or interface";
    private String xmlRootElementsExtend = null;
    private List<String> xmlRootElementsImplement = new LinkedList<String>();
    private String xmlTypesExtend = null;
    private List<String> xmlTypesImplement = new LinkedList<String>();
    private List<String> jaxbElementsImplement = new LinkedList<String>();

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public String getXmlRootElementsExtend() {
        return this.xmlRootElementsExtend;
    }

    public void setXmlRootElementsExtend(String globalElementsExtend) {
        this.xmlRootElementsExtend = globalElementsExtend;
    }

    public String getXmlRootElementsImplement() {
        return this.xmlRootElementsImplement.toString();
    }

    public void setXmlRootElementsImplement(String xmlRootElementsImplement) {
        this.xmlRootElementsImplement.add(xmlRootElementsImplement);
    }

    public String getXmlTypesExtend() {
        return this.xmlTypesExtend;
    }

    public void setXmlTypesExtend(String globalComplexTypesExtend) {
        this.xmlTypesExtend = globalComplexTypesExtend;
    }

    public String getXmlTypesImplement() {
        return this.xmlTypesImplement.toString();
    }

    public void setXmlTypesImplement(String xmlTypesImplement) {
        this.xmlTypesImplement.add(xmlTypesImplement);
    }

    public String getJaxbElementsImplement() {
        return this.jaxbElementsImplement.toString();
    }

    public void setJaxbElementsImplement(String jaxbElementsImplement) {
        this.jaxbElementsImplement.add(jaxbElementsImplement);
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  XmlRootElementsExtend....: " + this.getXmlRootElementsExtend());
            sb.append("\n  XmlRootElementsImplement.: " + this.getXmlRootElementsImplement());
            sb.append("\n  XmlTypesExtend...........: " + this.getXmlTypesExtend());
            sb.append("\n  XmlTypesImplement........: " + this.getXmlTypesImplement());
            sb.append("\n  JaxbElementsImplement....: " + this.getJaxbElementsImplement());
            sb.append("\n  Verbose..................: " + this.isVerbose());
            sb.append("\n  Debug....................: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (ClassOutline classOutline : outline.getClasses()) {
            if (classOutline.target.getElementName() != null) {
                this.processGlobalElement(classOutline);
                continue;
            }
            this.processGlobalComplexType(classOutline);
        }
        for (CElementInfo elementInfo : outline.getModel().getAllElements()) {
            ElementOutline elementOutline = outline.getElement(elementInfo);
            if (elementOutline == null) continue;
            this.processGlobalJAXBElement(elementOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    protected void processGlobalElement(ClassOutline classOutline) {
        this.generateExtends(classOutline.implClass, this.xmlRootElementsExtend);
        this.generateImplements(classOutline.implClass, this.xmlRootElementsImplement);
    }

    protected void processGlobalJAXBElement(ElementOutline elementOutline) {
        this.generateImplements(elementOutline.implClass, this.jaxbElementsImplement);
    }

    protected void processGlobalComplexType(ClassOutline classOutline) {
        this.generateExtends(classOutline.implClass, this.xmlTypesExtend);
        this.generateImplements(classOutline.implClass, this.xmlTypesImplement);
    }

    private void generateExtends(JDefinedClass theClass, String name) {
        if (name != null) {
            JClass targetClass = theClass.owner().ref(name);
            if (theClass._extends() == theClass.owner().ref(Object.class)) {
                theClass._extends(targetClass);
                this.debug("{}, generateExtends; Class={}, Extension={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name(), name});
            }
        }
    }

    private void generateImplements(JDefinedClass theClass, List<String> names) {
        if (names != null && !names.isEmpty()) {
            for (String name : names) {
                this.generateImplements(theClass, name);
            }
        }
    }

    private void generateImplements(JDefinedClass theClass, String name) {
        if (name != null) {
            JClass targetClass = theClass.owner().ref(name);
            theClass._implements(targetClass);
            this.debug("{}, generateImplements; Class={}, Interface={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name(), name});
        }
    }
}

