/*
 * Decompiled with CFR 0.152.
 */
package org.parceler.converter;

import android.os.Parcel;
import android.util.SparseArray;
import org.parceler.ParcelConverter;

public abstract class SparseArrayParcelConverter<T>
implements ParcelConverter<SparseArray<T>> {
    @Override
    public void toParcel(SparseArray<T> input, Parcel parcel) {
        if (input == null) {
            parcel.writeInt(-1);
        } else {
            parcel.writeInt(input.size());
            for (int i = 0; i < input.size(); ++i) {
                parcel.writeInt(input.keyAt(i));
                this.itemToParcel(input.valueAt(i), parcel);
            }
        }
    }

    @Override
    public SparseArray<T> fromParcel(Parcel parcel) {
        SparseArray array;
        int size = parcel.readInt();
        if (size < 0) {
            array = null;
        } else {
            array = new SparseArray(size);
            for (int i = 0; i < size; ++i) {
                int key = parcel.readInt();
                array.append(key, this.itemFromParcel(parcel));
            }
        }
        return array;
    }

    public abstract void itemToParcel(T var1, Parcel var2);

    public abstract T itemFromParcel(Parcel var1);
}

