/*
 * Decompiled with CFR 0.152.
 */
package org.parceler;

import android.os.Parcelable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.parceler.NonParcelRepository;
import org.parceler.ParcelWrapper;
import org.parceler.ParcelerRuntimeException;
import org.parceler.Repository;

public final class Parcels {
    public static final String PARCELS_NAME = "Parcels";
    public static final String PARCELS_REPOSITORY_NAME = "Parceler$$Parcels";
    public static final String PARCELS_PACKAGE = "org.parceler";
    public static final String IMPL_EXT = "Parcelable";
    private static final ParcelCodeRepository REPOSITORY = new ParcelCodeRepository();

    private Parcels() {
    }

    protected static void update(ClassLoader classLoader) {
        REPOSITORY.loadRepository(classLoader);
    }

    public static <T> Parcelable wrap(T input) {
        if (input == null) {
            return null;
        }
        return Parcels.wrap(input.getClass(), input);
    }

    public static <T> Parcelable wrap(Class<? extends T> inputType, T input) {
        if (input == null) {
            return null;
        }
        ParcelableFactory parcelableFactory = REPOSITORY.get(inputType);
        return parcelableFactory.buildParcelable(input);
    }

    public static <T> T unwrap(Parcelable input) {
        if (input == null) {
            return null;
        }
        ParcelWrapper wrapper = (ParcelWrapper)input;
        return wrapper.getParcel();
    }

    static {
        REPOSITORY.loadRepository(NonParcelRepository.getInstance());
    }

    private static final class ParcelCodeRepository {
        private ConcurrentMap<Class, ParcelableFactory> generatedMap = new ConcurrentHashMap<Class, ParcelableFactory>();

        public ParcelCodeRepository() {
            this.loadRepository(this.getClass().getClassLoader());
        }

        public ParcelableFactory get(Class clazz) {
            ParcelableFactory result = (ParcelableFactory)this.generatedMap.get(clazz);
            if (result == null) {
                ParcelableFactory value = this.findClass(clazz);
                if (Parcelable.class.isAssignableFrom(clazz)) {
                    value = new NonParcelRepository.ParcelableParcelableFactory();
                }
                if (value == null) {
                    throw new ParcelerRuntimeException("Unable to find generated Parcelable class for " + clazz.getName() + ", verify that your class is configured properly and that the Parcelable class " + ParcelCodeRepository.buildParcelableImplName(clazz) + " is generated by Parceler.");
                }
                result = this.generatedMap.putIfAbsent(clazz, value);
                if (result == null) {
                    result = value;
                }
            }
            return result;
        }

        private static String buildParcelableImplName(Class clazz) {
            return clazz.getName() + "$$" + Parcels.IMPL_EXT;
        }

        public ParcelableFactory findClass(Class clazz) {
            try {
                Class<?> parcelWrapperClass = Class.forName(ParcelCodeRepository.buildParcelableImplName(clazz));
                return new ParcelableFactoryReflectionProxy(clazz, parcelWrapperClass);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public void loadRepository(ClassLoader classLoader) {
            try {
                Class<?> repositoryClass = classLoader.loadClass("org.parceler.Parceler$$Parcels");
                this.loadRepository((Repository)repositoryClass.newInstance());
            }
            catch (ClassNotFoundException repositoryClass) {
            }
            catch (InstantiationException e) {
                throw new ParcelerRuntimeException("Unable to instantiate generated Repository", e);
            }
            catch (IllegalAccessException e) {
                throw new ParcelerRuntimeException("Unable to access generated Repository", e);
            }
        }

        public void loadRepository(Repository<ParcelableFactory> repository) {
            this.generatedMap.putAll(repository.get());
        }
    }

    private static final class ParcelableFactoryReflectionProxy<T>
    implements ParcelableFactory<T> {
        private final Constructor<? extends Parcelable> constructor;

        public ParcelableFactoryReflectionProxy(Class<T> parcelClass, Class<? extends Parcelable> parcelWrapperClass) {
            try {
                this.constructor = parcelWrapperClass.getConstructor(parcelClass);
            }
            catch (NoSuchMethodException e) {
                throw new ParcelerRuntimeException("Unable to create ParcelFactory Type", e);
            }
        }

        @Override
        public Parcelable buildParcelable(T input) {
            try {
                return this.constructor.newInstance(input);
            }
            catch (InstantiationException e) {
                throw new ParcelerRuntimeException("Unable to create ParcelFactory Type", e);
            }
            catch (IllegalAccessException e) {
                throw new ParcelerRuntimeException("Unable to create ParcelFactory Type", e);
            }
            catch (InvocationTargetException e) {
                throw new ParcelerRuntimeException("Unable to create ParcelFactory Type", e);
            }
        }
    }

    public static interface ParcelableFactory<T> {
        public static final String BUILD_PARCELABLE = "buildParcelable";

        public Parcelable buildParcelable(T var1);
    }
}

